% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\docType{class}
\name{Constraint-class}
\alias{Constraint-class}
\alias{Constraint}
\alias{show,Constraint-method}
\alias{ConditionalConstraint-class}
\alias{<=,AbstractConditionalScore,numeric-method}
\alias{>=,AbstractConditionalScore,numeric-method}
\alias{<=,numeric,AbstractConditionalScore-method}
\alias{>=,numeric,AbstractConditionalScore-method}
\alias{<=,AbstractConditionalScore,AbstractConditionalScore-method}
\alias{>=,AbstractConditionalScore,AbstractConditionalScore-method}
\alias{UnconditionalConstraint-class}
\alias{<=,UnconditionalScore,numeric-method}
\alias{>=,UnconditionalScore,numeric-method}
\alias{<=,numeric,UnconditionalScore-method}
\alias{>=,numeric,UnconditionalScore-method}
\alias{<=,UnconditionalScore,UnconditionalScore-method}
\alias{>=,UnconditionalScore,UnconditionalScore-method}
\title{Formulating constraints}
\usage{
\S4method{show}{Constraint}(object)

\S4method{<=}{AbstractConditionalScore,numeric}(e1, e2)

\S4method{>=}{AbstractConditionalScore,numeric}(e1, e2)

\S4method{<=}{numeric,AbstractConditionalScore}(e1, e2)

\S4method{>=}{numeric,AbstractConditionalScore}(e1, e2)

\S4method{<=}{AbstractConditionalScore,AbstractConditionalScore}(e1, e2)

\S4method{>=}{AbstractConditionalScore,AbstractConditionalScore}(e1, e2)

\S4method{<=}{UnconditionalScore,numeric}(e1, e2)

\S4method{>=}{UnconditionalScore,numeric}(e1, e2)

\S4method{<=}{numeric,UnconditionalScore}(e1, e2)

\S4method{>=}{numeric,UnconditionalScore}(e1, e2)

\S4method{<=}{UnconditionalScore,UnconditionalScore}(e1, e2)

\S4method{>=}{UnconditionalScore,UnconditionalScore}(e1, e2)
}
\arguments{
\item{object}{object of class \code{Constraint}}

\item{e1}{first comparator}

\item{e2}{second comparator}

\item{...}{further optional arguments}
}
\description{
Conceptually, constraints work very similar to scores (any score can be put in
a constraint).
Currently,  constraints of the form 'score <=/>= x',
'x <=/>= score' and 'score <=/>= score' are admissable.
}
\examples{
cp          <- ConditionalPower(Normal(), PointMassPrior(0.4, 1))
pow         <- expected(cp)
constraint1 <- pow >= 0.8 # an unconditional power constraint
constraint2 <- cp >= 0.7 # a conditional power constraint
constraint3 <- 0.7 <= cp # yields the same as constraint2

}
