% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{six_leaves_graphs}
\alias{six_leaves_graphs}
\title{Six leaves graphs.}
\format{A list of functions on six leaves and a parameter \code{permutations} which
        is \code{FALSE} by default.
        The outputs of these functions are either single \code{\link{agraph}} objects
        with the input vector as leaves, or if \code{permutations} is \code{TRUE},
        lists of all the possible \code{\link{agraph}} objects with that leaf set up
        to symmetry.}
\usage{
six_leaves_graphs
}
\description{
Kind of obsolete since the introduction of \code{\link{all_graphs}}.
A comprehensive listing of all the \eqn{21} admixture graphs with six leaves and
at most one admixture event. Our convention is that the position of the root does
not matter (as long as it's not after an admixture event) and that graphs that have
\emph{eyes}, two inner nodes with the property that all the paths between any two
leaves visits both or neither of them, are excluded. The reason  is that the \eqn{f}
statistics can't detect the exact position of the root or distinguish between an
eye and a simple branch. The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(six_leaves_graphs))) {
  graph <- six_leaves_graphs[[i]](c("A", "B", "C", "D", "E", "F"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("six_leaves_graphs[[", i,
                 "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\", \\"F\\"))", sep = "")
  plot(graph, color = "yellow4", title = title)
}
}

}
\seealso{
\code{\link{all_graphs}}

\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{fit_graph_list}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{eight_leaves_trees}},
  \code{\link{five_leaves_graphs}},
  \code{\link{four_leaves_graphs}},
  \code{\link{seven_leaves_graphs}}
}
\keyword{datasets}

