% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{run_metropolis_hasting}
\alias{run_metropolis_hasting}
\title{Run a Metropolis-Hasting MCMC to sample graph parameters.}
\usage{
run_metropolis_hasting(model, initial_state, iterations, no_temperatures = 1,
  cores = 1, no_flips = 1, max_tmp = 100, verbose = TRUE)
}
\arguments{
\item{model}{Object constructed with \code{\link{make_mcmc_model}}.}

\item{initial_state}{The initial set of graph parameters.}

\item{iterations}{Number of iterations to sample.}

\item{no_temperatures}{Number of chains in the MC3 procedure.}

\item{cores}{Number of cores to spread the chains across. Best performance is when \code{cores = no_temperatures}.}

\item{no_flips}{Mean number of times a flip between two chains should be proposed after each step.}

\item{max_tmp}{The highest temperature.}

\item{verbose}{Logical value determining if a progress bar should be shown during the run.}
}
\value{
A matrix containing the trace of the chain with temperature 1.
}
\description{
The MCMC performs a random walk in transformed parameter space (edge lengths are log transformed
and admixture proportions inverse Normal distribution transformed) and from this
explores the posterior distribution of graph parameters.
}
\details{
Using the posterior distribution of parameters is one approach to getting parameter estimates
and a sense of their variability. Credibility intervals can directly be obtained from sampled
parameters; to get confidence intervals from the likelihood maximisation approach requires
either estimating the Hessian matrix for the likelihood or a boot-strapping approach
to the data.

From sampling the likelihood values for each sample from the posterior we can also
compute the model likelihood (the probability of the data when integrating over all the model
parameters). This gives us a direct way of comparing graphs since the ratio of likelihoods
is the Bayes factor between the models. Comparing models using maximum likelihood estimtates
is more problematic since usually graphs are not nested models.
}

