% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\name{rename_nodes}
\alias{rename_nodes}
\title{Rename nodes.}
\usage{
rename_nodes(graph, newnames = list())
}
\arguments{
\item{graph}{The graph to be renamed.}

\item{newnames}{A list of new names, given in the form \code{list(old = "new")}. Nodes not listed will keep
their old name, unless no list is given at all, in which case the leaves keep their old
names while the inner nodes get new standardised names.}
}
\value{
A graph with new node names.
}
\description{
Changes the names of the nodes of a graph.
Capable of giving new standard names to the inner nodes in a way that only depends on the graph topology
(without the root) and the leaf names. This is necessary when detecting when graphs are identical up to inner
node and admixture proportion names, see \code{\link{canonise_graph}} and \code{\link{remove_duplicates}}.
}

