% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_plotting.R
\name{plot_fit_2}
\alias{plot_fit_2}
\title{A contour plot of the cost function.}
\usage{
plot_fit_2(object, X, Y, resolution = 10, show_fit = FALSE, sigma = 6,
  grayscale = FALSE, ...)
}
\arguments{
\item{object}{The fitted object.}

\item{X}{An admix variable name (remember quotation marks).}

\item{Y}{An admix variable name (remember quotation marks).}

\item{resolution}{How densely is the function evaluated.}

\item{show_fit}{Should the function plot the number of statistics where the graph fits
the data instead of the \code{\link{cost_function}}?}

\item{sigma}{If \code{show_fit} is \code{TRUE} then each statistic is considered fitted
if the difference between a prediction and the observation statistics is no
more than \eqn{D*\sigma/(2*Z)}. Notice that even when plotting the number of
fitted statistics, we have no guarantee that the chosen variables maximize
this number as the fitting function still optimizes \code{\link{cost_function}}.}

\item{grayscale}{Should the figure be plotted in grayscale or in colour?}

\item{...}{Additional parameters passed to the plotting function
\code{\link{contour}}.}
}
\value{
The matrix of values computed and plotted.
}
\description{
A contour plot of the cost function with respect to two admix variables specified by the user.
}
\seealso{
\code{\link{contour}}

\code{\link{plot_fit_1}}
}

