% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{six_leaves_graphs}
\alias{six_leaves_graphs}
\title{Six leaves graphs.}
\format{\preformatted{List of 21
 $ tree_1          :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1130 12 1146 3 12 3 1130 1146
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ tree_2          :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1148 12 1164 3 12 3 1148 1164
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_1 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1167 21 1187 3 21 3 1167 1187
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_2 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1189 21 1209 3 21 3 1189 1209
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_3 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1211 21 1231 3 21 3 1211 1231
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_4 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1233 21 1253 3 21 3 1233 1253
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_5 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1255 21 1275 3 21 3 1255 1275
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_6 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1277 21 1297 3 21 3 1277 1297
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_7 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1299 21 1319 3 21 3 1299 1319
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_8 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1321 21 1341 3 21 3 1321 1341
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_9 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1343 21 1363 3 21 3 1343 1363
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_10:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1365 22 1385 3 22 3 1365 1385
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_11:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1387 22 1407 3 22 3 1387 1407
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_12:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1409 22 1429 3 22 3 1409 1429
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_13:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1431 22 1451 3 22 3 1431 1451
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_14:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1453 22 1473 3 22 3 1453 1473
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_15:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1475 22 1495 3 22 3 1475 1495
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_16:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1497 22 1517 3 22 3 1497 1517
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_17:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1519 22 1539 3 22 3 1519 1539
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_18:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1541 22 1561 3 22 3 1541 1561
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_19:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1563 22 1583 3 22 3 1563 1583
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
}}
\usage{
six_leaves_graphs
}
\value{
A list of functions on six leaves.
        The outputs of these functions are \code{\link{agraph}} objects.
}
\description{
A comprehensive listing of all the \eqn{21} admixture graphs with six leaves and
at most one admixture event. Our convention is that the position of the root does
not matter (as long as it's not after an admixture event) and that graphs that have
\emph{eyes}, two inner nodes with the property that all the paths between any two
leaves visits both or neither of them, are excluded. The reason  is that the \eqn{f}
statistics can't detect the exact position of the root or distinguish between an
eye and a simple branch. The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(six_leaves_graphs))) {
  graph <- six_leaves_graphs[[i]](c("A", "B", "C", "D", "E", "F"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("six_leaves_graphs[[", i,
                 "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\", \\"F\\"))", sep = "")
  plot(graph, color = "yellow4", title = title)
}
}
}
\seealso{
\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{eight_leaves_trees}};
  \code{\link{five_leaves_graphs}};
  \code{\link{four_leaves_graphs}};
  \code{\link{seven_leaves_trees}}
}
\keyword{datasets}

