% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{four_leaves_graphs}
\alias{four_leaves_graphs}
\title{Four leaves graphs.}
\format{\preformatted{List of 35
 $ tree             :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 172 10 184 3 10 3 172 184
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_1  :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 187 21 203 3 21 3 187 203
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_2  :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 205 21 221 3 21 3 205 221
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_3  :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 223 21 239 3 21 3 223 239
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_1 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 242 22 261 3 22 3 242 261
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_2 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 263 22 282 3 22 3 263 282
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_3 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 284 22 303 3 22 3 284 303
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_4 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 305 22 324 3 22 3 305 324
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_5 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 326 22 345 3 22 3 326 345
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_6 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 347 22 366 3 22 3 347 366
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_7 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 368 22 387 3 22 3 368 387
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_8 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 389 22 408 3 22 3 389 408
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_9 :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 410 22 429 3 22 3 410 429
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_10:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 431 23 450 3 23 3 431 450
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_11:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 452 23 471 3 23 3 452 471
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_12:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 473 23 492 3 23 3 473 492
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_13:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 494 23 513 3 23 3 494 513
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_14:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 515 23 534 3 23 3 515 534
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_15:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 536 23 555 3 23 3 536 555
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_16:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 557 23 576 3 23 3 557 576
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_17:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 578 23 597 3 23 3 578 597
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_18:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 599 23 618 3 23 3 599 618
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_19:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 620 23 639 3 23 3 620 639
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_20:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 641 23 660 3 23 3 641 660
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_21:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 662 23 681 3 23 3 662 681
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_22:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 683 23 702 3 23 3 683 702
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_23:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 704 23 723 3 23 3 704 723
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_24:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 725 23 744 3 23 3 725 744
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_25:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 746 23 765 3 23 3 746 765
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_26:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 767 23 786 3 23 3 767 786
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_27:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 788 23 807 3 23 3 788 807
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_28:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 809 23 828 3 23 3 809 828
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_29:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 830 23 849 3 23 3 830 849
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_30:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 851 23 870 3 23 3 851 870
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ two_admixtures_31:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 872 23 891 3 23 3 872 891
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
}}
\usage{
four_leaves_graphs
}
\value{
A list of functions on four leaves.
        The outputs of these functions are \code{\link{agraph}} objects.
}
\description{
A comprehensive listing of all the \eqn{35} admixture graphs with four leaves and
at most two admixture events. Our convention is that the position of the root does
not matter (as long as it's not after an admixture event) and that graphs that have
\emph{eyes}, two inner nodes with the property that all the paths between any two
leaves visits both or neither of them, are excluded. The reason is that the \eqn{f}
statistics  can't detect the exact position of the root or distinguish between an
eye and a simple branch. The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(four_leaves_graphs))) {
  graph <- four_leaves_graphs[[i]](c("A", "B", "C", "D"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("four_leaves_graphs[[", i, "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\"))", sep = "")
  plot(graph, color = "tomato3", title = title)
}
}
}
\seealso{
\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{eight_leaves_trees}};
  \code{\link{five_leaves_graphs}};
  \code{\link{seven_leaves_trees}};
  \code{\link{six_leaves_graphs}}
}
\keyword{datasets}

