% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{five_leaves_graphs}
\alias{five_leaves_graphs}
\title{Five leaves graphs.}
\format{\preformatted{List of 8
 $ tree           :function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 933 10 947 3 10 3 933 947
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_1:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 950 21 968 3 21 3 950 968
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_2:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 970 21 988 3 21 3 970 988
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_3:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 990 21 1008 3 21 3 990 1008
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_4:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1010 21 1028 3 21 3 1010 1028
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_5:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1030 21 1048 3 21 3 1030 1048
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_6:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1050 21 1068 3 21 3 1050 1068
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ one_admixture_7:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1070 21 1088 3 21 3 1070 1088
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
}}
\usage{
five_leaves_graphs
}
\value{
A list of functions on five leaves.
        The outputs of these functions are \code{\link{agraph}} objects.
}
\description{
A comprehensive listing of all the \eqn{8} admixture graphs with five leaves and
at most one admixture event. Our convention is that the position of the root does
not matter (as long as it's not after an admixture event) and that graphs that have
\emph{eyes}, two inner nodes with the property that all the paths between any two
leaves visits both or neither of them, are excluded. The reason is that the \eqn{f}
statistics can't detect the exact position of the root or distinguish between an eye
and a simple branch. The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(five_leaves_graphs))) {
  graph <- five_leaves_graphs[[i]](c("A", "B", "C", "D", "E"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("five_leaves_graphs[[", i, "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\"))",
                 sep = "")
  plot(graph, color = "purple", title = title)
}
}
}
\seealso{
\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{eight_leaves_trees}};
  \code{\link{four_leaves_graphs}};
  \code{\link{seven_leaves_trees}};
  \code{\link{six_leaves_graphs}}
}
\keyword{datasets}

