% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsimmix.R
\name{rsimmix_mix}
\alias{rsimmix_mix}
\title{Simulation of a two-component gaussian mixture with one component following a two-component gaussian mixture}
\usage{
rsimmix_mix(n, m, s, p, a)
}
\arguments{
\item{n}{is the number of observations to be drawn}

\item{m}{the mean (up to the shift a) of the unknown components}

\item{s}{the standard deviation of the unknown components}

\item{p}{the weight of the unknown component (itself a mixture).}

\item{a}{the shift of the mean for the two distributions that are embedded in the unknown component}
}
\value{
a list containing the data generated from a mixture of mixture distribution, the data where the known component density has
been made uniform(0,1), and the known data (corresponding to the part of data generated from the known component density).
}
\description{
Simulate a two-component gaussian admixture model, where the first component is a gaussian mixture itself
}
\examples{
sample1 <- rsimmix_mix(n = 3000, m = 5, s = 0.5, p = 0.3, a = 2)[['mixt.data']]
plot(stats::density(sample1))

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
