#' Exposure Ophthalmology SDTM Dataset
#'
#' An example Exposure SDTM dataset with ophthalmology-specific variables such as EXLOC and EXLAT
#' @keywords datasets
#' @family datasets
#' @source
#' Constructed using `ex` from the `{admiral}` package
#'
"admiralophtha_ex"

#' Best Corrected Visual Acuity Analysis Dataset
#'
#' An example Best Corrected Visual Acuity (BCVA) analysis dataset
#' @keywords datasets
#' @family datasets
#' @source
#' Derived from the `oe` and `ADSL` datasets using `{admiral}`, `{admiralophtha}` and
#' (\url{https://github.com/pharmaverse/admiralophtha/blob/main/inst/templates/ad_adbcva.R})
#'
"admiralophtha_adbcva"

#' Visual Function Questionnaire Analysis Dataset
#'
#' An example Visual Function Questionnaire (VFQ) analysis dataset
#' @keywords datasets
#' @family datasets
#' @source
#' Derived from the `ADSL` and `qs` datasets using `{admiral}`, `{admiralophtha}` and
#' (\url{https://github.com/pharmaverse/admiralophtha/blob/main/inst/templates/ad_advfq.R})
#'
"admiralophtha_advfq"

#' Ophthalmology Exam Analysis Dataset
#'
#' An example Ophthalmology Exam Analysis dataset
#' @keywords datasets
#' @family datasets
#' @source
#' Derived from the `oe` and `ADSL` datasets using `{admiral}`, `{admiralophtha}` and
#' (\url{https://github.com/pharmaverse/admiralophtha/blob/main/inst/templates/ad_adoe.R})
#'
"admiralophtha_adoe"

#' Ophthalmology Questionnaires SDTM Dataset
#'
#' An example Questionnaires SDTM dataset with ophthalmology-specific questionnaire of NEI VFQ-25
#' @keywords datasets
#' @family datasets
#' @source
#' Constructed using `qs` from the `{admiral}` package
#'
"admiralophtha_qs"
