% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_date_vector}
\alias{assert_date_vector}
\title{Is an object a date or datetime vector?}
\usage{
assert_date_vector(arg, optional = TRUE)
}
\arguments{
\item{arg}{The function argument to be checked}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE}
and \code{arg} is \code{NULL} then the function \code{assert_date_vector} exits early and throw and error.}
}
\value{
The function returns an error if \code{arg} is missing, or not a date or datetime variable
but otherwise returns an invisible output.
}
\description{
Check if an object/vector is a date or datetime variable without needing a dataset as input
}
\examples{
example_fun <- function(arg) {
  assert_date_vector(arg)
}

example_fun(
  as.Date("2022-01-30", tz = "UTC")
)
try(example_fun("1993-07-14"))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\author{
Sadchla Mascary
}
\concept{assertion}
\keyword{assertion}
