% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{add_suffix_to_vars}
\alias{add_suffix_to_vars}
\title{Add a Suffix to Variables in a List of Quosures}
\usage{
add_suffix_to_vars(order, vars, suffix)
}
\arguments{
\item{order}{List of quosures

\emph{Permitted Values}: list of variables or \verb{desc(<variable>)} function calls
created by \code{vars()}, e.g., \code{vars(ADT, desc(AVAL))}}

\item{vars}{Variables to change

\emph{Permitted Values}: list of variables created by \code{vars()}}

\item{suffix}{Suffix

\emph{Permitted Values}: A character scalar}
}
\value{
The list of quosures where for each element the suffix (\code{suffix}) is
added to every symbol specified for \code{vars}
}
\description{
Add a suffix to variables in a list of quosures
}
\examples{
library(dplyr, warn.conflicts = FALSE)

add_suffix_to_vars(vars(ADT, desc(AVAL), AVALC), vars = vars(AVAL), suffix = ".join")
}
\seealso{
Helpers for working with Quosures: 
\code{\link{quo_c}()},
\code{\link{quo_not_missing}()},
\code{\link{replace_symbol_in_quo}()},
\code{\link{replace_values_by_names}()}
}
\author{
Stefan Bundfuss
}
\concept{quo}
\keyword{quo}
