% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_age_years.R
\name{compute_age_years}
\alias{compute_age_years}
\title{Compute Age in Years}
\usage{
compute_age_years(age, age_unit)
}
\arguments{
\item{age}{The ages to convert.

A numeric vector is expected.

\describe{
\item{Default value}{none}
}}

\item{age_unit}{Age unit.

Either a string containing the time unit of all ages in \code{age} or a character
vector containing the time units of each age in \code{age} is expected. Note that
permitted values are cases insensitive (e.g. \code{"YEARS"} is treated the same
as \code{"years"} and \code{"Years"}).

\describe{
\item{Permitted values}{\code{"years"}, \code{"months"}, \code{"weeks"}, \code{"days"}, \code{"hours"}, \code{"minutes"},
\code{"seconds"}, \code{NA_character_}.}
\item{Default value}{none}
}}
}
\value{
The ages contained in \code{age} converted to years.
}
\description{
Converts a set of age values from the specified time unit to years.
}
\details{
Returns a numeric vector of ages in years as doubles. Note
that passing \code{NA_character_} as a unit will result in an \code{NA} value for the outputted
age. Also note, underlying computations assume an equal number of days in each
year (365.25).
}
\examples{
compute_age_years(
  age = c(240, 360, 480),
  age_unit = "MONTHS"
)

compute_age_years(
  age = c(10, 520, 3650, 1000),
  age_unit = c("YEARS", "WEEKS", "DAYS", NA_character_)
)

}
\seealso{
Date/Time Computation Functions that returns a vector: 
\code{\link{compute_dtf}()},
\code{\link{compute_duration}()},
\code{\link{compute_tmf}()},
\code{\link{convert_date_to_dtm}()},
\code{\link{convert_dtc_to_dt}()},
\code{\link{convert_dtc_to_dtm}()},
\code{\link{impute_dtc_dt}()},
\code{\link{impute_dtc_dtm}()}
}
\concept{com_date_time}
\keyword{com_date_time}
