% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_disposition_status.R
\name{format_eoxxstt_default}
\alias{format_eoxxstt_default}
\title{Default Format for Disposition Status}
\usage{
format_eoxxstt_default(status)
}
\arguments{
\item{status}{the disposition variable used for the mapping (e.g. \code{DSDECOD}).}
}
\value{
A \code{character} vector derived based on the values given in \code{status}:
"NOT STARTED" if \code{status} is "SCREEN FAILURE" or "SCREENING NOT COMPLETED",
"COMPLETED" if \code{status} is "COMPLETED",
"DISCONTINUED" if \code{status} is not in ("COMPLETED","SCREEN FAILURE",
"SCREENING NOT COMPLETED") nor NA,
"ONGOING" otherwise.
}
\description{
Define a function to map the disposition status. To be used as an input for
\code{derive_var_disposition_status()}.
}
\details{
Usually this function can not be used with \verb{\%>\%}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("admiral_dm")
data("admiral_ds")

admiral_dm \%>\%
  derive_var_disposition_status(
    dataset_ds = admiral_ds,
    new_var = EOSSTT,
    status_var = DSDECOD,
    format_new_var = format_eoxxstt_default,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, EOSSTT)
}
\seealso{
\code{\link[=derive_var_disposition_status]{derive_var_disposition_status()}}

Utilities for Formatting Observations: 
\code{\link{convert_blanks_to_na}()},
\code{\link{format_reason_default}()},
\code{\link{yn_to_numeric}()}
}
\author{
Samia Kabi
}
\concept{utils_fmt}
\keyword{utils_fmt}
