% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_function}
\alias{assert_function}
\title{Is Argument a Function?}
\usage{
assert_function(arg, params = NULL, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{params}{A character vector of expected parameter names}

\item{optional}{Is the checked parameter optional?

If set to \code{FALSE} and \code{arg} is \code{NULL} then an error is thrown.}
}
\value{
The function throws an error
\itemize{
\item if the argument is not a function or
\item if the function does not provide all parameters as specified for the
\code{params} parameter.
}
}
\description{
Checks if the argument is a function and if all expected parameters are
provided by the function.
}
\examples{
example_fun <- function(fun) {
  assert_function(fun, params = c("x"))
}

example_fun(mean)

try(example_fun(1))

try(example_fun(sum))
}
\author{
Stefan Bundfuss
}
\keyword{assertion}
