% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_disposition_status.R
\name{derive_var_disposition_status}
\alias{derive_var_disposition_status}
\title{Derive a Disposition Status at a Specific Timepoint}
\usage{
derive_var_disposition_status(
  dataset,
  dataset_ds,
  new_var,
  status_var,
  format_new_var = format_eoxxstt_default,
  filter_ds,
  subject_keys = vars(STUDYID, USUBJID)
)
}
\arguments{
\item{dataset}{Input dataset.}

\item{dataset_ds}{Dataset containing the disposition information (e.g.: ds).

It must contain:
\itemize{
\item \code{STUDYID}, \code{USUBJID},
\item The variable(s) specified in the \code{status_var}
\item The variables used in \code{filter_ds}.
}}

\item{new_var}{Name of the disposition status variable.

A variable name is expected (e.g. \code{EOSSTT}).}

\item{status_var}{The variable used to derive the disposition status.

A variable name is expected (e.g. \code{DSDECOD}).}

\item{format_new_var}{The format used to derive the status.

Default: \code{format_eoxxstt_default()} defined as:

\if{html}{\out{<div class="sourceCode">}}\preformatted{format_eoxxstt_default <- function(status) \{
  case_when(
    status == "COMPLETED" ~ "COMPLETED",
    status != "COMPLETED" & !is.na(status) ~ "DISCONTINUED",
    TRUE ~ "ONGOING"
  )
\}
}\if{html}{\out{</div>}}

where \code{status} is the \code{status_var.}}

\item{filter_ds}{Filter condition for the disposition data.

one observation per patient. An error is issued otherwise.

Permitted Values: logical expression.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
The input dataset with the disposition status (\code{new_var}) added.
\code{new_var} is derived based on the values given in \code{status_var} and according to the format
defined by \code{format_new_var} (e.g. when the default format is used, the function will derive
\code{new_var} as:
"COMPLETED" if \code{status_var} == "COMPLETED",
"DISCONTINUED" if \code{status_var} is not "COMPLETED" nor NA,
"ONGOING" otherwise).
}
\description{
Derive a disposition status from the the relevant records in the disposition domain.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("admiral_dm")
data("admiral_ds")

# Default derivation: EOSSTT =
#- COMPLETED when status_var = COMPLETED
#- DISCONTINUED when status_var is not COMPLETED nor NA
#- ONGOING otherwise

admiral_dm \%>\%
  derive_var_disposition_status(
    dataset_ds = admiral_ds,
    new_var = EOSSTT,
    status_var = DSDECOD,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, EOSSTT)

# Specific derivation: EOSSTT =
#- COMPLETED when status_var = COMPLETED
#- DISCONTINUED DUE TO AE when status_var = ADVERSE EVENT
#- DISCONTINUED NOT DUE TO AE when status_var != ADVERSE EVENT nor COMPLETED nor missing
#- ONGOING otherwise

format_eoxxstt1 <- function(x) {
  case_when(
    x == "COMPLETED" ~ "COMPLETED",
    x == "ADVERSE EVENT" ~ "DISCONTINUED DUE TO AE",
    !(x \%in\% c("ADVERSE EVENT", "COMPLETED")) & !is.na(x) ~ "DISCONTINUED NOT DUE TO AE",
    TRUE ~ "ONGOING"
  )
}

admiral_dm \%>\%
  derive_var_disposition_status(
    dataset_ds = admiral_ds,
    new_var = EOSSTT,
    status_var = DSDECOD,
    format_new_var = format_eoxxstt1,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, EOSSTT)
}
\author{
Samia Kabi
}
\keyword{adsl}
