% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{assert_terms}
\alias{assert_terms}
\title{Asserts Requirements for Terms for Queries}
\usage{
assert_terms(terms, expect_grpname = FALSE, expect_grpid = FALSE, source_text)
}
\arguments{
\item{terms}{Terms provided by user}

\item{expect_grpname}{Is the \code{GRPNAME} column expected?}

\item{expect_grpid}{Is the \code{GRPID} column expected?}

\item{source_text}{Text describing the source of the terms, e.g., \verb{"the data frame provided for the }definition\verb{ element"}.}
}
\value{
An error is issued if
\itemize{
\item \code{terms} is not a data frame,
\item \code{terms} has zero observations,
\item the \code{SRCVAR} variable is not in \code{terms},
\item neither the \code{TERMNAME} nor the \code{TERMID} variable is in \code{terms},
\item \code{expect_grpname == TRUE} and the \code{GRPNAME} variable is not in \code{terms},
\item \code{expect_grpid == TRUE} and the \code{GRPID} variable is not in \code{terms},
}
}
\description{
The function checks the requirements for terms for queries provided by the
user. The terms could have been provided directly in the query definition or
via a user provided function for accessing a SMQ or SDG database.
}
\examples{

try(
  assert_terms(
    terms = 42,
    source_text = "object provided by the `definition` element"
  )
)
}
\seealso{
\code{\link[=create_query_data]{create_query_data()}}, \code{\link[=query]{query()}}

Other Advanced Functions: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_parameters_argument}()},
\code{\link{assert_valid_queries}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{get_hori_data}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\concept{other_advanced}
\keyword{other_advanced}
