% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_extreme_event.R
\name{derive_extreme_event}
\alias{derive_extreme_event}
\title{Add the Worst or Best Observation for Each By Group as New Records}
\usage{
derive_extreme_event(
  dataset,
  by_vars = NULL,
  events,
  order,
  mode,
  check_type = "warning",
  set_values_to
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{order} and the \code{by_vars} parameter are
expected.}

\item{by_vars}{Grouping variables

\emph{Default}: \code{NULL}

\emph{Permitted Values:} list of variables created by \code{exprs()}}

\item{events}{Conditions and new values defining events

A list of \code{event()} objects is expected. Only observations listed in the
\code{events} are considered for deriving extreme event. If multiple records
meet the filter \code{condition}, take the first record sorted by \code{order}.}

\item{order}{Sort order

If a particular event from \code{events} has more than one observation, within
the event and by group, the records are ordered by the specified order.

\emph{Permitted Values:} list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))}}

\item{mode}{Selection mode (first or last)

If a particular event from \code{events} has more than one observation,
"first"/"last" is to select the first/last record of this type of events
sorting by \code{order}.

\emph{Permitted Values:} \code{"first"}, \code{"last"}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

\emph{Default:} \code{"warning"}

\emph{Permitted Values:} \code{"none"}, \code{"warning"}, \code{"error"}}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations.

A list of variable name-value pairs is expected.
\itemize{
\item LHS refers to a variable.
\item RHS refers to the values to set to the variable. This can be a string, a
symbol, a numeric value, an expression, or \code{NA}, e.g., \code{exprs(PARAMCD =   "TDOSE", PARCAT1 = "OVERALL")}.
}}
}
\value{
The input dataset with the best or worst observation of each by group
added as new observations.
}
\description{
Add the first available record from \code{events} for each by group as new
records, all variables of the selected observation are kept. It can be used
for selecting the extreme observation from a series of user-defined events.
This distinguish \code{derive_extreme_event()} from \code{derive_extreme_records()},
where extreme records are derived based on certain order of existing
variables.
}
\details{
\enumerate{
\item Construct a dataset based on \code{events}: apply the filter \code{condition} and
\code{set_values_to} to the input dataset.
\item For each group (with respect to the variables specified for the
\code{by_vars} parameter) the first or last observation (with respect to the
order specified for the \code{order} parameter and the mode specified for the
\code{mode} parameter) is selected.
\item The variables specified by the \code{set_values_to} parameter are added to
the selected observations.
\item The observations are added to input dataset.
}
}
\examples{
library(tibble)

adqs <- tribble(
  ~USUBJID, ~PARAMCD,       ~AVALC,        ~ADY,
  "1",      "NO SLEEP",     "N",              1,
  "1",      "WAKE UP",      "N",              2,
  "1",      "FALL ASLEEP",  "N",              3,
  "2",      "NO SLEEP",     "N",              1,
  "2",      "WAKE UP",      "Y",              2,
  "2",      "WAKE UP",      "Y",              3,
  "2",      "FALL ASLEEP",  "N",              4,
  "3",      "NO SLEEP",     NA_character_,    1
)

# Add a new record for each USUBJID storing the the worst sleeping problem.
derive_extreme_event(
  adqs,
  by_vars = exprs(USUBJID),
  events = list(
    event(
      condition = PARAMCD == "NO SLEEP" & AVALC == "Y",
      set_values_to = exprs(AVALC = "No sleep", AVAL = 1)
    ),
    event(
      condition = PARAMCD == "WAKE UP" & AVALC == "Y",
      set_values_to = exprs(AVALC = "Waking up more than three times", AVAL = 2)
    ),
    event(
      condition = PARAMCD == "FALL ASLEEP" & AVALC == "Y",
      set_values_to = exprs(AVALC = "More than 30 mins to fall asleep", AVAL = 3)
    ),
    event(
      condition = all(AVALC == "N"),
      set_values_to = exprs(
        AVALC = "No sleeping problems", AVAL = 4
      )
    ),
    event(
      condition = TRUE,
      set_values_to = exprs(AVALC = "Missing", AVAL = 99)
    )
  ),
  order = exprs(ADY),
  mode = "last",
  set_values_to = exprs(
    PARAMCD = "WSP",
    PARAM = "Worst Sleeping Problems"
  )
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_extreme_record}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
