% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strataMethods.R
\docType{methods}
\name{setPop}
\alias{setPop}
\alias{setPop,genind-method}
\alias{setPop,genlight-method}
\alias{setPop<-}
\alias{setPop<-,genind-method}
\alias{setPop<-,genlight-method}
\title{Manipulate the population factor of genind objects.}
\usage{
setPop(x, formula = NULL)

setPop(x) <- value
}
\arguments{
\item{x}{a genind or genlight object}

\item{formula}{a nested formula indicating the order of the population
strata.}

\item{value}{same as formula}
}
\description{
The following methods allow the user to quickly change the population of a 
genind object.
}
\examples{

data(microbov)

strata(microbov) <- data.frame(other(microbov))

# Currently set on just 
head(pop(microbov)) 

# setting the strata to both Pop and Subpop
setPop(microbov) <- ~coun/breed 
head(pop(microbov))

\dontrun{

# Can be used to create objects as well.
microbov.old <- setPop(microbov, ~spe) 
head(pop(microbov.old))
}
}
\author{
Zhian N. Kamvar
}

