% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_funs.R
\name{prob_better}
\alias{prob_better}
\title{Calculate the probabilities that each arm is better than a common control}
\usage{
prob_better(
  m,
  control = NULL,
  highest_is_best = FALSE,
  equivalence_diff = NULL,
  futility_diff = NULL
)
}
\arguments{
\item{m}{a matrix with one column per trial arm (named as the \code{arms}) and one
row for each draw from the posterior distributions.}

\item{control}{a single character string specifying the common \code{control} arm.}

\item{highest_is_best}{single logical, specifies whether larger estimates of
the outcome are favourable or not; defaults to \code{FALSE}, corresponding to,
e.g., an undesirable binary outcomes (e.g., mortality) or a continuous
outcome where lower numbers are preferred (e.g., hospital length of stay).}

\item{equivalence_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no equivalence assessment). If a numeric value is
specified, estimated differences below this threshold will be considered
equivalent when assessing equivalence. For designs with a common \code{control}
arm, the differences between each non-control arm and the \code{control} arm is
used, and for trials without a common \code{control} arm, the difference between
the highest and lowest estimated outcome rates are used and the trial is
only stopped for equivalence if all remaining arms are thus equivalent.}

\item{futility_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no futility assessment). If a numeric value is specified,
estimated differences below this threshold in the \emph{beneficial} direction
(as specified in \code{highest_is_best}) will be considered futile when
assessing futility in designs with a common \code{control} arm. If only 1 arm
remains after dropping arms for futility, the trial will be stopped without
declaring the last arm superior.}
}
\value{
A named (rownames corresponding to the trial \code{arms}) \code{matrix}
containing 1-3 columns: \code{probs_better}, \code{probs_equivalence} (if
\code{equivalence_diff} is specified), and \code{probs_futile} (if \code{futility_diff} is
specified). All columns will contain \code{NA} for the control arm.
}
\description{
Used internally. This function takes a \code{matrix} as calculated by the
\link{get_draws_binom}, \link{get_draws_norm} or a corresponding custom function (as
specified using the \code{fun_draws} argument in \link{setup_trial}; see
\link{get_draws_generic}) and a single character specifying the \code{control} arm, and
calculates the probabilities of each arm being better than a common \code{control}
(defined as either higher or lower than the \code{control}, as specified by the
\code{highest_is_best} argument in \link{setup_trial}, \link{setup_trial_binom} or
\link{setup_trial_norm}). This function also calculates equivalence and futility
probabilities compared to the common \code{control} arm, as specified in
\link{setup_trial}, \link{setup_trial_binom} or \link{setup_trial_norm}, unless
\code{equivalence_diff} or \code{futility_diff}, respectively, are set to \code{NULL}
(the default).
}
\keyword{internal}
