% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_sync.R
\name{idSync}
\alias{idSync}
\title{Returns the source files needed to repair synchrony}
\usage{
idSync(file.info, dag.to.sync)
}
\arguments{
\item{file.info}{Project file information}

\item{dag.to.sync}{Directed Acyclic graph in need of synchronization}
}
\value{
data.frame with sources that need to be run, rows in run order
}
\description{
Returns the source files needed to repair synchrony
}
\examples{
\dontrun{
projInfo <- getProjectInfo(pullSourceInfo("adaprHome")$dependency.dir)
trees <- readDependency(pullSourceInfo("adaprHome")$dependency.dir)
file.info <-condenseFileInfo(trees)
idSync(file.info,projInfo$graph) 
} 
}
