% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_provenance.R
\name{gitProvenance}
\alias{gitProvenance}
\title{Identify git provenance of file within a project}
\usage{
gitProvenance(project.id, filepath = 0)
}
\arguments{
\item{project.id}{Project id to search for history within}

\item{filepath}{File that will be hashed and search within Git history, File choose dialogue if not specified}
}
\value{
list of 1) filename, 2) Git commit including commit message, date, author and 2) file info
}
\description{
Identify git provenance of file within a project
}
\details{
Requires a Git commit snapshot within the project
}
\examples{
\dontrun{
 projpath <- file.path(getProjectPath("adaprHome"),"Programs")
 gitProvenance("adaprHome",file.path(projpath,"read_data.R"))
} 

}
