% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trx_stats.R
\name{trx_stats}
\alias{trx_stats}
\alias{summary.trx_df}
\title{Summarize transactions and utilization rates}
\usage{
trx_stats(
  .data,
  trx_types,
  percent_of = NULL,
  combine_trx = FALSE,
  col_exposure = "exposure",
  full_exposures_only = TRUE,
  conf_int = FALSE,
  conf_level = 0.95
)

\method{summary}{trx_df}(object, ...)
}
\arguments{
\item{.data}{A data frame with exposure-level records of type
\code{exposed_df} with transaction data attached. If necessary, use
\code{\link[=as_exposed_df]{as_exposed_df()}} to convert a data frame to an \code{exposed_df} object, and use
\code{\link[=add_transactions]{add_transactions()}} to attach transactions to an \code{exposed_df} object.}

\item{trx_types}{A character vector of transaction types to include in the
output. If none is provided, all available transaction types in \code{.data}
will be used.}

\item{percent_of}{A optional character vector containing column names in
\code{.data} to use as denominators in the calculation of utilization rates or
actual-to-expected ratios.}

\item{combine_trx}{If \code{FALSE} (default), the results will contain output rows
for each transaction type. If \code{TRUE}, the results will contains aggregated
experience across all transaction types.}

\item{col_exposure}{Name of the column in \code{.data} containing exposures}

\item{full_exposures_only}{If \code{TRUE} (default), partially exposed records will
be excluded from \code{data}.}

\item{conf_int}{If \code{TRUE}, the output will include confidence intervals
around the observed utilization rate and any \code{percent_of} output columns.}

\item{conf_level}{Confidence level for confidence intervals}

\item{object}{A \code{trx_df} object}

\item{...}{Groups to retain after \code{summary()} is called}
}
\value{
A tibble with class \code{trx_df}, \code{tbl_df}, \code{tbl},
and \code{data.frame}. The results include columns for any grouping
variables and transaction types, plus the following:
\itemize{
\item \code{trx_n}: the number of unique transactions.
\item \code{trx_amt}: total transaction amount
\item \code{trx_flag}: the number of observation periods with non-zero transaction amounts.
\item \code{exposure}: total exposures
\item \code{avg_trx}: mean transaction amount (\code{trx_amt / trx_flag})
\item \code{avg_all}: mean transaction amount over all records (\code{trx_amt / exposure})
\item \code{trx_freq}: transaction frequency when a transaction occurs (\code{trx_n / trx_flag})
\item \code{trx_utilization}: transaction utilization per observation period (\code{trx_flag / exposure})
}

If \code{percent_of} is provided, the results will also include:
\itemize{
\item The sum of any columns passed to \code{percent_of} with non-zero transactions.
These columns include the suffix \verb{_w_trx}.
\item The sum of any columns passed to \code{percent_of}
\item \verb{pct_of_\{*\}_w_trx}: total transactions as a percentage of column
\verb{\{*\}_w_trx}. In other words, total transactions divided by the sum of a
column including only records utilizing transactions.
\item \verb{pct_of_\{*\}_all}: total transactions as a percentage of column \verb{\{*\}}. In
other words, total transactions divided by the sum of a column regardless
of whether or not transactions were utilized.
}

If \code{conf_int} is set to \code{TRUE}, additional columns are added for lower and
upper confidence interval limits around the observed utilization rate and any
\code{percent_of} output columns. Confidence interval columns include the name
of the original output column suffixed by either \verb{_lower} or \verb{_upper}.
\itemize{
\item If values are passed to \code{percent_of}, an additional column is created
containing the the sum of squared transaction amounts (\code{trx_amt_sq}).
}
}
\description{
Create a summary data frame of transaction counts, amounts,
and utilization rates.
}
\details{
Unlike \code{\link[=exp_stats]{exp_stats()}}, this function requires \code{data} to be an
\code{exposed_df} object.

If \code{.data} is grouped, the resulting data frame will contain
one row per transaction type per group.

Any number of transaction types can be passed to the \code{trx_types} argument,
however each transaction type \strong{must} appear in the \code{trx_types} attribute of
\code{.data}. In addition, \code{trx_stats()} expects to see columns named \verb{trx_n_\{*\}}
(for transaction counts) and \verb{trx_amt_\{*\}} for (transaction amounts) for each
transaction type. To ensure \code{.data} is in the appropriate format, use the
functions \code{\link[=as_exposed_df]{as_exposed_df()}} to convert an existing data frame with
transactions or \code{\link[=add_transactions]{add_transactions()}} to attach transactions to an existing
\code{exposed_df} object.
}
\section{"Percentage of" calculations}{
The \code{percent_of} argument is optional. If provided, this argument must
be a character vector with values corresponding to columns in \code{.data}
containing values to use as denominators in the calculation of utilization
rates or actual-to-expected ratios. Example usage:
\itemize{
\item In a study of partial withdrawal transactions, if \code{percent_of} refers to
account values, observed withdrawal rates can be determined.
\item In a study of recurring claims, if \code{percent_of} refers to a column
containing a maximum benefit amount, utilization rates can be determined.
}
}

\section{Confidence intervals}{
If \code{conf_int} is set to \code{TRUE}, the output will contain lower and upper
confidence interval limits for the observed utilization rate and any
\code{percent_of} output columns. The confidence level is dictated
by \code{conf_level}.
\itemize{
\item Intervals for the utilization rate (\code{trx_util}) assume a binomial
distribution.
\item Intervals for transactions as a percentage of another column with
non-zero transactions (\verb{pct_of_\{*\}_w_trx}) are constructed using a normal
distribution
\item Intervals for transactions as a percentage of another column
regardless of transaction utilization (\verb{pct_of_\{*\}_all}) are calculated
assuming that the aggregate distribution is normal with a mean equal to
observed transactions and a variance equal to:

\code{Var(S) = E(N) * Var(X) + E(X)^2 * Var(N)},

Where \code{S} is the aggregate transactions random variable, \code{X} is an individual
transaction amount assumed to follow a normal distribution, and \code{N} is a
binomial random variable for transaction utilization.
}
}

\section{Default removal of partial exposures}{
As a default, partial exposures are removed from \code{.data} before summarizing
results. This is done to avoid complexity associated with a lopsided skew
in the timing of transactions. For example, if transactions can occur on a
monthly basis or annually at the beginning of each policy year, partial
exposures may not be appropriate. If a policy had an exposure of 0.5 years
and was taking withdrawals annually at the beginning of the year, an
argument could be made that the exposure should instead be 1 complete year.
If the same policy was expected to take withdrawals 9 months into the year,
it's not clear if the exposure should be 0.5 years or 0.5 / 0.75 years.
To override this treatment, set \code{full_exposures_only} to \code{FALSE}.
}

\section{\code{summary()} Method}{
Applying \code{summary()} to a \code{trx_df} object will re-summarize the
data while retaining any grouping variables passed to the "dots"
(\code{...}).
}

\examples{
expo <- expose_py(census_dat, "2019-12-31", target_status = "Surrender") |>
  add_transactions(withdrawals)

res <- expo |> group_by(inc_guar) |> trx_stats(percent_of = "premium")
res

summary(res)

expo |> group_by(inc_guar) |>
  trx_stats(percent_of = "premium", combine_trx = TRUE, conf_int = TRUE)

}
