% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierCredGLM.R
\name{hierCredGLM}
\alias{hierCredGLM}
\title{Combining the hierarchical credibility model with a GLM (Ohlsson, 2008)}
\usage{
hierCredGLM(
  formula,
  data,
  weights,
  p = 1.5,
  link.power = 0,
  muHatGLM = TRUE,
  epsilon = 1e-04,
  maxiter = 500,
  maxiterGLM = 500,
  verbose = FALSE,
  returnData = TRUE,
  balanceProperty = TRUE,
  y = TRUE,
  ...
)
}
\arguments{
\item{formula}{object of type \code{\link{formula}} that specifies which model should be fitted. Syntax is the same as for
\code{\link[lme4]{lmer}} and \code{\link[lme4]{glmer}}. For example, \code{Yijkt ~ x1 + x2 + (1 | Industry / Branch)}.}

\item{data}{an object that is coercible by \code{\link[data.table]{as.data.table}}, containing the variables in the model.}

\item{weights}{variable name of the exposure weight.}

\item{p}{the value for the power parameter of the Tweedie distribution, which is passed to \code{\link[statmod]{tweedie}}. Default is \code{1.5}.}

\item{link.power}{index of power link function, which is passed to \code{\link[statmod]{tweedie}}. \code{link.power = 0} produces a log-link.
Defaults to the canonical link, which is \code{1 - p}.}

\item{muHatGLM}{indicates which estimate has to be used in the algorithm for the intercept term. Default is \code{TRUE},
which used the intercept as estimated by the GLM. If \code{FALSE}, the estimate of the hierarchical credibility model is used.}

\item{epsilon}{positive convergence tolerance \eqn{\epsilon}; the iterations converge when 7
\eqn{||\theta[k] - \theta[k - 1]||^2[[2]]/||\theta[k - 1]||^2[[2]] < \epsilon}. Here, \eqn{\theta[k]} is the parameter vector at the \eqn{k^{th}} iteration.}

\item{maxiter}{maximum number of iterations.}

\item{maxiterGLM}{maximum number of iterations when fitting the GLM part. Passed to \code{glm}.}

\item{verbose}{logical indicating if output should be produced during the algorithm.}

\item{returnData}{logical indicating if input data has to be returned.}

\item{balanceProperty}{logical indicating if the balance property should be satisfied.}

\item{y}{logical indicating whether the response vector should be returned as a component of the returned value.}

\item{...}{arguments passed to \code{glm}}
}
\value{
An object of type \code{hierCredGLM} with the following slots:

\item{call}{the matched call}

\item{HierarchicalResults}{results of the hierarchical credibility model.}

\item{fitGLM}{the results from fitting the GLM part.}

\item{iter}{total number of iterations.}

\item{Converged}{logical indicating whether the algorithm converged.}

\item{LevelsCov}{object that summarizes the unique levels of each of the contract-specific covariates.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}

\item{prior.weights}{the weights (exposure) initially supplied.}

\item{y}{if requested, the response vector. Default is \code{TRUE}.}
}
\description{
Fit a random effects model using Ohlsson's methodology. In this function you explicitly specify the power parameter p.
See \code{\link{hierCredTweedie}} when you also want to estimate the p.
}
\examples{
\donttest{
data("dataCar")
fit = hierCredGLM(Y ~ area + (1 | VehicleType / VehicleBody), dataCar, weights = w,
p = 1.7)
fit
summary(fit)
ranef(fit)
fixef(fit)
}
}
\references{
Campo, B.D.C. and Antonio, Katrien (2023). Insurance pricing with hierarchically structured data an illustration with a workers' compensation insurance portfolio. \emph{Scandinavian Actuarial Journal}, doi: 10.1080/03461238.2022.2161413

Ohlsson, E. (2008). Combining generalized linear models and credibility models in practice. \emph{Scandinavian Actuarial Journal} \bold{2008}(4), 301–314.
}
\seealso{
\code{\link{hierCredGLM-class}}, \code{\link{fitted.hierCredGLM}}, \code{\link{predict.hierCredGLM}}, \code{\link{ranef-actuaRE}},
\code{\link{weights-actuaRE}}, \code{\link{hierCredibility}}, \code{\link{hierCredTweedie}}, \code{\link{plotRE}},
 \code{\link{adjustIntercept}}, \code{\link{BalanceProperty}}
}
