% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMM.R
\name{componentsplot}
\alias{componentsplot}
\title{GCMM components plot}
\usage{
componentsplot(
  model,
  rug = FALSE,
  ruglwd = 2,
  lwd = 3,
  col = c("black", "grey40", "grey60", "grey80")
)
}
\arguments{
\item{model}{Model output from GCMM function, object of class \code{GCMM}}

\item{rug}{Logical argument for whether to plot a rug of the raw values. Plotting the rug for the separate components requires that saveclustIDs=TRUE when running GCMM. default=FALSE}

\item{ruglwd}{Line width for rug plot}

\item{lwd}{Line width for activity curve lines}

\item{col}{Character vector for colours for the activity curve lines and rug plot; must be of equal length to the number of components}
}
\value{
Plot of the separate components of the circular mixture model
}
\description{
Plot of activity curves for the separate components in the circular mixture model
}
\examples{
\donttest{ componentsplot(FoxActivityGCMM) }
 
}
