% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotTimes}
\alias{plotTimes}
\title{Print circular graphics for time series.}
\usage{
plotTimes(
  times,
  night = NULL,
  col,
  alpha = 0.8,
  title = "",
  mean.dash = TRUE,
  mean.range = TRUE,
  mean.range.darken.factor = 1.4,
  rings = TRUE,
  file,
  width,
  height,
  bg = "transparent",
  ncol,
  legend.pos = c("auto", "corner", "bottom"),
  ylegend,
  xlegend,
  xjust = c("auto", "centre", "left", "right"),
  expand = 0.95,
  cex = 1
)
}
\arguments{
\item{times}{A list of of time vectors (each vector will be plotted as a series).}

\item{night}{A vector of two times defining the start and stop of the night period (in HH:MM format).}

\item{col}{A vector of colour names to paint each time series (colours will be added transparency).}

\item{alpha}{A value between 0 and 1 for the opacity of each layer (defaults to 0.8).}

\item{title}{A title for the plot.}

\item{mean.dash}{Logical: Should the mean value be displayed on the plot's edge?}

\item{mean.range}{Logical: Should the SEM be displayed? (only relevant if mean.dash = TRUE)}

\item{mean.range.darken.factor}{A numeric factor to darken the mean range edges for each group. Values greater
than 1 darken the colour, and values lower than 1 lighten the colour.}

\item{rings}{Logical: Should inner plot rings be displayed?}

\item{file}{A file name to save the plot to. Leave NULL to plot on active graphics device. Available file extensions: .svg, .pdf, .png and .tiff.}

\item{height, width}{The height and width of the output file. Use inches for .pdf and .svg files or pixels for .png and .tiff files.}

\item{bg}{The colour of the plot background. Defaults to "transparent".}

\item{ncol}{The number of columns in which to set the legend items. By default, actel decides the number
of columns based on the number of data series to be plotted.}

\item{legend.pos}{Where should the legend be drawn? By default, actel decides whether to plot the legend
in the corner of the plot at the bottom the plot depending on the number of data series to plot.
Possible values: 'auto', 'corner', 'bottom'.}

\item{ylegend}{Adjustment to the vertical positioning of the legend. Only relevant if the legend is being drawn
in the corner of the plot.}

\item{xlegend}{Adjustment to the horizontal positioning of the legend.}

\item{xjust}{How the legend is to be justified when the legend is drawn at the bottom a the plot.
One of 'auto' (i.e. let actel decide the best adjustment), 'left', 'centre', or 'right'.}

\item{expand}{Parameter that controls the size of the plotted circle. Defaults to 0.95. Larger values expand the circle, while smaller values shrink the circle.}

\item{cex}{A numerical vector giving the amount by which plotting characters and symbols should be scaled
relative to the default. When saving the plot in a vectorial form, it is recommended to change the height
and width arguments rather than the cex.}
}
\value{
A circular plot
}
\description{
Wraps functions adapted from the circular R package.
}
\details{
For more details about the original functions, visit the circular package homepage at \url{https://github.com/cran/circular}
}
\examples{
# The output of timesToCircular can be used as an input to plotTimes.
x <- getTimes(example.results, location = "A1", n.events = "first", event.type = "arrival")
times <- timesToCircular(x)

# plot times
plotTimes(times)

# A night period can be added with 'night'
plotTimes(times, night = c("20:00", "06:00"))

}
