% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{loadShape}
\alias{loadShape}
\title{Load shapefile and convert to a raster object.}
\usage{
loadShape(
  path = ".",
  shape,
  size,
  spatial = "spatial.csv",
  coord.x = NULL,
  coord.y = NULL,
  buffer = NULL,
  type = c("land", "water")
)
}
\arguments{
\item{path}{The system path to the 'shape' file. Defaults to the current directory.}

\item{shape}{A shape file containing land polygons of the study area.}

\item{size}{The pixel size, in metres.}

\item{spatial}{Either a character string specifying the path to a spatial.csv file or a spatial data frame.
This argument is not mandatory, but can be used to perform an early check of the shape file's compatibility
with the study stations and release sites.}

\item{coord.x, coord.y}{The names of the columns containing the x and y positions of the stations
in the spatial.csv file. these coordinates MUST BE in the same coordinate system as the shape file.}

\item{buffer}{Artificially expand the shape file edges. Can be a single value (applied to all edges)
or four values (xmin, xmax, ymin, ymax). The unit of the buffer depends on the shape file's
coordinate system.}

\item{type}{The type of shapefile being loaded. One of "land" or "water".}
}
\value{
A raster object.
}
\description{
loadShape can also perform early quality checks on the shape file, to ensure it is compatible
with the remaining study data. To activate these, set the names of the columns in the spatial.csv
file that contain the x and y coordinates of the stations using coord.x and coord.y. By default,
loadShape looks for a spatial.csv file in the current working directory, but this can be
personalized using the spatial argument.
}
\details{
It is highly recommended to read the vignette regarding distances matrix before running this function.
You can find it by running \code{vignette('a-2_distances_matrix', 'actel')} or \code{browseVignettes('actel')}
}
\examples{
\donttest{
# check if R can run the distance functions
aux <- c(
  length(suppressWarnings(packageDescription("raster"))),
  length(suppressWarnings(packageDescription("gdistance"))),
  length(suppressWarnings(packageDescription("sp"))),
  length(suppressWarnings(packageDescription("tools"))),
  length(suppressWarnings(packageDescription("rgdal"))))
missing.packages <- sapply(aux, function(x) x == 1)

if (any(missing.packages)) {
  message("Sorry, this function requires packages '",
    paste(c("raster", "gdistance", "sp", "tools", "rgdal")[missing.packages], collapse = "', '"),
    "' to operate. Please install ", ifelse(sum(missing.packages) > 1, "them", "it"),
    " before proceeding.")
} else {
  if (suppressWarnings(require("rgdal"))) {
    # Fetch actel's example shapefile location
    aux <- system.file(package = "actel")[1]

    # import the shape file
    x <- loadShape(path = aux, shape = "example_shapefile.shp", size = 20)

    # have a look at the resulting raster,
    # where the blank spaces are the land areas
    raster::plot(x)
  } else {
    message("Sorry, it appears that rgdal is not being able to load.")
  }
}
rm(aux, missing.packages)
}
}
