% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_load.R
\name{matrix_load}
\alias{matrix_load}
\title{Load replacement matrix}
\usage{
matrix_load(path = NULL, myFileEncoding = "UTF-8")
}
\arguments{
\item{path}{Character string; path to the replacement matrix (a CSV file). If argument is left open, the default replacement matrix of the package will be returned.}

\item{myFileEncoding}{Character string; encoding of the file.}
}
\value{
Data.frame
}
\description{
This function is only for checking how the normalization matrix will be loaded internally.
}
\examples{
library(act)

# An example replacement matrix comes with the package.
path <- system.file("extdata", "normalization", "normalizationMatrix.csv", package="act")

# Load the matrix
mymatrix <- act::matrix_load(path)

# Have a look at the matrix
colnames(mymatrix)
mymatrix

#the original path of the matrix is stored in the attributes
attr(mymatrix, 'path') 
}
