% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_printtranscript.R
\name{export_printtranscript}
\alias{export_printtranscript}
\title{Export a transcript object to a print transcript}
\usage{
export_printtranscript(
  t,
  l = NULL,
  outputPath = NULL,
  filterTierNames = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL,
  insert_arrow_annotationID = "",
  header_heading = "",
  header_firstinfo = "",
  alignBrackets = FALSE
)
}
\arguments{
\item{t}{Transcript object.}

\item{l}{Layout object.}

\item{outputPath}{Character string; path where to save the transcript.}

\item{filterTierNames}{Vector of character strings; names of tiers to be included. If left unspecified, all tiers will be exported.}

\item{filterSectionStartsec}{Double; start of selection in seconds.}

\item{filterSectionEndsec}{Double; end of selection in seconds.}

\item{insert_arrow_annotationID}{Integer; ID of the annotation in front of which the arrow will be placed.}

\item{header_heading}{Character string; text that will be used as heading.}

\item{header_firstinfo}{Character string; text that will used as first information in the header.}

\item{alignBrackets}{Logical; if \code{TRUE} the function will align [] brackets that signal overlapping speech (attention: experimental function; results may not satisfy)}
}
\value{
Character string; transcript as text.
}
\description{
If you want to modify the layout of the print transcripts, create a new layout object with \code{mylayout <- methods::new("layout")}, modify the settings and pass it as argument \code{l}.
}
\examples{
library(act)

# Get a transcript
t <- examplecorpus@transcripts[[1]]

# Create print transcript
printtranscript <- act::export_printtranscript (t=t)

# Display on screen
cat(stringr::str_c(printtranscript, sep="\n", collapse = "\n"))

}
\seealso{
\code{corpus_export}, \code{export_eaf}, \code{export_exb}, \code{export_rpraat}, \code{export_srt}, \code{export_textgrid}
}
