% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_rpraat.R
\name{import_rpraat}
\alias{import_rpraat}
\title{Import a single 'rPraat' TextGrid object}
\usage{
import_rpraat(rPraatTextGrid, transcriptName = NULL)
}
\arguments{
\item{rPraatTextGrid}{List; rPraat TextGrid object.}

\item{transcriptName}{Character string; name of the transcript.}
}
\value{
Transcript object.
}
\description{
This function is to create compatibility with the \code{rPraat} package. 
It converts a 'rPraat' TextGrid object into an act transcript object.
}
\details{
Please note:
- Time values of annotations in TextGrids may be below 0 seconds. Negative time values will be recognized corretly in the first place. When exporting transcript object to other formats like 'ELAN' .eaf, 'EXMARaLDA' .exb ect. annotations that are completely before 0 sec will be deleted, annotations that start before but end after 0 sec will be truncated. Please see also the function \code{act::transcripts_cure_single}.  
- TextGrids and contained tiers may start and end at different times. These times do not need to match each other. The act package does not support start and end times of TextGrids and tiers and will. The default start of a TextGrid will be 0 seconds or the lowest value in case that annotations start below 0 seconds.

Credits to Tomáš Bořil, the author of the rPraat package, for commenting on the exchange functions.
}
\examples{
library(act)

# Path to the .TextGrid file that you want to read
path <- system.file("extdata", "examplecorpus", "GAT", 
					"ARG_I_PAR_Beto.TextGrid", package="act")

# To import a .TextGrid file of your choice:
\dontrun{
	path <- "PATH_TO_AN_EXISTING_TEXTGRID_ON_YOUR_COMPUTER"
}

# Make sure to have rPraat installed before you try the following
\dontrun{
	# Read TextGrid file with rPraat
	rPraat.tg <- rPraat::tg.read(path)

	# Convert to an act transcript
	t <- act::import_rpraat(rPraat.tg)
	
	# Change the name and add it to the examplecorpus
	t@name <-"rpraat"
	newcorpus <- act::transcripts_add(examplecorpus, t)
	
	# Have a look
	newcorpus@transcripts[["rpraat"]]
	
	# Alternatively, you can use the general import function
	t <- act::import(rPraat.tg)
}
}
\seealso{
\code{corpus_import}, \code{corpus_new}, \code{import}, \code{import_eaf}, \code{import_exb}, \code{import_textgrid}

\link{export_rpraat}, \link{import}, \link{import_textgrid}, \link{import_eaf}
}
