% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDAP.R
\name{SDAP}
\alias{SDAP}
\alias{SDAP.default}
\title{Sparse Discriminant Analysis solved via Proximal Gradient}
\usage{
SDAP(x, ...)

\method{SDAP}{default}(
  Xt,
  Yt,
  Om,
  gam,
  lam,
  q,
  PGsteps,
  PGtol,
  maxits,
  tol,
  initTheta,
  bt = FALSE,
  L,
  eta
)
}
\arguments{
\item{Xt}{n by p data matrix, (not a data frame, but a matrix)}

\item{Yt}{n by K matrix of indicator variables (Yij = 1 if i in class j).
This will later be changed to handle factor variables as well.
Each observation belongs in a single class, so for a given row/observation,
only one element is 1 and the rest is 0.}

\item{Om}{p by p parameter matrix Omega in generalized elastic net penalty.}

\item{gam}{Regularization parameter for elastic net penalty.}

\item{lam}{Regularization parameter for l1 penalty, must be greater than zero.}

\item{q}{Desired number of discriminant vectors.}

\item{PGsteps}{Maximum number if inner proximal gradient algorithm for finding beta.}

\item{PGtol}{Stopping tolerance for inner APG method.}

\item{maxits}{Number of iterations to run}

\item{tol}{Stopping tolerance for proximal gradient algorithm.}

\item{initTheta}{Initial first theta, default value is a vector of ones.}

\item{bt}{Boolean to indicate whether backtracking should be used, default false.}

\item{L}{Initial estimate for Lipshitz constant used for backtracking.}

\item{eta}{Scalar for Lipshitz constant.}
}
\value{
\code{SDAP} returns an object of \code{\link{class}} "\code{SDAP}" including a list
with the following named components: (More will be added later to handle the predict function)

\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{B}}{p by q matrix of discriminant vectors.}
  \item{\code{Q}}{K by q matrix of scoring vectors.}
  \item{\code{subits}}{Total number of iterations in proximal gradient subroutine.}
  \item{\code{totalits}}{Number coordinate descent iterations for all discriminant vectors}
}

\code{NULL}
}
\description{
Applies proximal gradient algorithm to
the optimal scoring formulation of sparse discriminant analysis proposed
by Clemmensen et al. 2011.
}
\seealso{
\code{SDAPcv}, \code{\link{SDAAP}} and \code{\link{SDAD}}
}
\keyword{internal}
