% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_timeline.R
\name{get_user_timeline}
\alias{get_user_timeline}
\title{Get tweets by a single user}
\usage{
get_user_timeline(
  x,
  start_tweets,
  end_tweets,
  bearer_token = get_bearer(),
  n = 100,
  file = NULL,
  data_path = NULL,
  export_query = TRUE,
  bind_tweets = TRUE,
  page_n = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{string containing one user id or a vector of user ids}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{n}{integer, upper limit of tweets to be fetched}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{export_query}{If \code{TRUE}, queries are exported to data_path}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{page_n}{integer, amount of tweets to be returned by per page}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{build_query()} function. See \code{?build_query()} for further information.}
}
\value{
a data.frame
}
\description{
This function collects tweets by an user ID from the users endpoint.
}
\details{
Only the most recent 3,200 Tweets can be retrieved.

If a filename is supplied, the function will
save the result as a RDS file.

If a data path is supplied, the function will also return
tweet-level data in a data/ path as a series of JSONs beginning "data_";
while user-level data will be returned as a series of JSONs beginning "users_".

When bind_tweets is \code{TRUE}, the function returns a data frame.
}
\examples{
\dontrun{

get_user_timeline("2244994945",
                  start_tweets = "2020-01-01T00:00:00Z", 
                  end_tweets = "2021-05-14T00:00:00Z",
                  bearer_token = get_bearer(),
                  n = 200)
}
}
