% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateabn.R
\name{simulateAbn}
\alias{simulateAbn}
\title{Simulate data from a fitted additive Bayesian network.}
\usage{
simulateAbn(
  object = NULL,
  run.simulation = TRUE,
  bugsfile = NULL,
  n.chains = 10L,
  n.adapt = 1000L,
  n.thin = 100L,
  n.iter = 10000L,
  seed = 42L,
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{object}{of type \code{abnFit}.}

\item{run.simulation}{call JAGS to simulate data (default is \code{TRUE}).}

\item{bugsfile}{A path to a valid file or \code{NULL} (default)  to delete the bugs file after simulation.}

\item{n.chains}{number of parallel chains for the model.}

\item{n.adapt}{number of iteration for adaptation. If \code{n.adapt} is set to zero, then no adaptation takes place.}

\item{n.thin}{thinning interval for monitors.}

\item{n.iter}{number of iteration to monitor.}

\item{seed}{by default set to 42.}

\item{verbose}{if TRUE prints additional output}

\item{debug}{if TRUE prints bug file content to stdout and does not run simulations.}
}
\value{
data.frame
}
\description{
Simulate data from a fitted additive Bayesian network.
}
\examples{
df <- FCV[, c(12:15)]
mydists <- list(Outdoor="binomial",
                Sex="multinomial",
                GroupSize="poisson",
                Age="gaussian")

## buildScoreCache -> mostProbable() -> fitAbn()
suppressWarnings({
  mycache.mle <- buildScoreCache(data.df = df, data.dists = mydists, method = "mle",
                                 adj.vars = NULL, cor.vars = NULL,
                                 dag.banned = NULL, dag.retained = NULL,
                                 max.parents = 1,
                                 which.nodes = NULL, defn.res = NULL)
}) # ignore non-convergence warnings
mp.dag.mle <- mostProbable(score.cache = mycache.mle, verbose = FALSE)
myres.mle <- fitAbn(object = mp.dag.mle, method = "mle")

myres.sim <- simulateAbn(object = myres.mle,
                             run.simulation = TRUE,
                             bugsfile = NULL,
                             verbose = FALSE)
str(myres.sim)
prop.table(table(myres.sim$Outdoor))
prop.table(table(df$Outdoor))

}
\seealso{
\link{makebugs}
}
