% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_afthreshold.R
\name{compute_afthreshold}
\alias{compute_afthreshold}
\title{Compute coverage-based and not-coverage-based allelic fraction thresholds}
\usage{
compute_afthreshold(outdir, pbem_dir = file.path(outdir,
  "BaseErrorModel"), outdir.afth.name = "Controls",
  coverage_binning = 50, probs = seq(0.9, 1, 1e-04))
}
\arguments{
\item{outdir}{The folder where outputs will be saved.}

\item{pbem_dir}{The folder with outputs generated by the \code{compute_pbem} function. default: file.path(outdir, "BaseErrorModel")}

\item{outdir.afth.name}{The subfolder name that will be created in the \code{outdir}. default: "Controls"}

\item{coverage_binning}{Bins of coverage into which divide AFs. default: 50}

\item{probs}{Quantiles dividing the distribution of allelic fractions.}
}
\value{
A matrix with allelic fraction thresholds. Rows are quantiles as set by \code{probs} and columns are coverage bins as set by \code{coverage_binning}
}
\description{
Compute coverage-based and not-coverage-based allelic fraction thresholds
}
\examples{
outdir <- tempdir()
pbem_dir <- system.file("extdata", "BaseErrorModel", package = "abemus")
outafth <- compute_afthreshold(outdir = outdir,pbem_dir = pbem_dir)
}
