% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_glm.R
\name{aba_plot_roc}
\alias{aba_plot_roc}
\title{Plot ROC curves from an aba model}
\usage{
aba_plot_roc(object)
}
\arguments{
\item{object}{abaSummary. A summary of an aba model with \code{stat_glm} type.}
}
\value{
a ggplot with roc curves for all predictor sets across each
group - outcome - stat combination
}
\description{
This function plots ROC curves across group - outcome - stat combinations
and currently supports \code{stat_glm}.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# fit glm model with binary outcome variables
model <- data \%>\% aba_model() \%>\%
  set_groups(everyone()) \%>\%
  set_outcomes(ConvertedToAlzheimers, CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(
    PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl,
    c(PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_stats(
    stat_glm(std.beta = TRUE)
  ) \%>\%
  fit()

# summarise glm model
model_summary <- model \%>\% summary()

fig <- model_summary \%>\% aba_plot_roc()

}
