% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GATES2.R
\name{GATES2}
\alias{GATES2}
\title{Gene-based Association Test that uses an extended Simes procedure (GATES) for single trait - SNP set association}
\usage{
GATES2(ldmatrix, p)
}
\arguments{
\item{ldmatrix}{numeric. A correlation matrix of SNPs,
dimensions matching the p and snps arguments.}

\item{p}{p-value for each SNPs.}
}
\value{
A p-value of GATES and the key gene location (to be used by Hyst).
}
\description{
Get the p-value of GATES. Usually it is used to get genomewise p-values.
This function is taken from postgwas package.
There is a little modification of the code GATES in postgwas package.
1) The approximated matrix may have negative eigen value, we modified it not to have negative values; 2) we added one more return (the key gene location) for Hyst method.
}
\examples{

simula <- simPathAR1Snp(nGenes=20, nGenes1=1, nSNPlim=c(1, 20), nSNP0=1:3,
                           LOR=.2, rholim=c(0,0),
                           n=100, MAFlim=c(0.05, 0.4), p0=0.05)
Ps <- getlogitp(simula$Y, simula$X)

## get correlation of SNPs using controls
ldmat <- cor(simula$X[ simula$Y == 0, ])

o.pvec = order(Ps)
 ldmat <- ldmat[o.pvec, o.pvec]
(gatesp <- GATES2(ldmat, sort(Ps))[1])


}
\references{
Miao-Xin Li, Hong-Sheng Gui, Johnny S.H. Kwan and Pak C. Sham (2011)
GATES: A Rapid and Powerful Gene-Based Association Test Using Extended Simes Procedure
The American Journal of Human Genetics 88, 283-293
}
\seealso{
\code{\link{Hyst}} \code{\link{GatesSimes}}
}
\author{
Milan Hiersche(taken from pastgwas package), Il-Youp Kwak(modified a little)
}
