% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathFraction.R
\docType{methods}
\name{PathFraction}
\alias{PathFraction}
\alias{PathFraction,aRchi-method}
\title{Compute the path fraction}
\usage{
PathFraction(aRchi)

\S4method{PathFraction}{aRchi}(aRchi)
}
\arguments{
\item{aRchi}{an object of class aRchi with at least the QSM and the Paths table}
}
\value{
The path fraction
}
\description{
Compute from an object of class aRchi the path fraction
}
\details{
The path fraction is the ratio between the mean path length and the maximum path length.
}
\examples{
# Read an aRchi file with at least the QSM and the paths table
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)

PathFraction(Tree1_aRchi)

}
\references{
Martin-Ducup, O. et al. Terrestrial laser scanning reveals convergence of tree architecture with increasingly dominant crown canopy position. Functional Ecology (2020).

Smith, D. D. et al. Deviation from symmetrically self-similar branching in trees predicts altered hydraulics, mechanics, light interception and metabolic scaling. New Phytologist 201, 217–229 (2014).
}
\seealso{
\code{\link{Make_Path}} to compute the paths table.
}
