% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZetaSuitSC.R
\name{ZetaSuitSC}
\alias{ZetaSuitSC}
\title{Calculation of zeta score for single cell RNA-seq.}
\usage{
ZetaSuitSC(countMatSC, binNum = 10, filter = TRUE)
}
\arguments{
\item{countMatSC}{Shalek input matrix}

\item{binNum}{bin number for ZetaScore calculation.}

\item{filter}{Whether to filter the extreme low read counts cells with nCount <100. default is TRUE}
}
\value{
A list of data.frame and plots. The data.frame is the Cell matrix with column name 'Cell' and 'Zeta'. The plot is the distribution of Zeta score for the detected cells and including a cut-off for removing the broken and empty cells.
}
\description{
This tool is used to evalucate the quality of cells detected in the single-cell RNA-seq. A zeta score will be assigned to each cell. And a cut-off for low quality and broken cells will be provided. The users can based on the selected cut-off to select the high quality cells for further analysis.
}
\examples{
data(countMatSC)
\donttest{zetaDataSC <- ZetaSuitSC(countMatSC,binNum=50,filter=TRUE)}

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
\keyword{cell}
\keyword{single}
