/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.FontFamily;
import org.apache.poi.ss.usermodel.FontScheme;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorders;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellStyleXfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellXfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFills;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFonts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmts;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTStylesheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.StyleSheetDocument;

public class StylesTable
extends POIXMLDocumentPart {
    private final Map<Integer, String> numberFormats = new LinkedHashMap<Integer, String>();
    private final List<XSSFFont> fonts = new ArrayList<XSSFFont>();
    private final List<XSSFCellFill> fills = new ArrayList<XSSFCellFill>();
    private final List<XSSFCellBorder> borders = new ArrayList<XSSFCellBorder>();
    private final List<CTXf> styleXfs = new ArrayList<CTXf>();
    private final List<CTXf> xfs = new ArrayList<CTXf>();
    private final List<CTDxf> dxfs = new ArrayList<CTDxf>();
    public static final int FIRST_CUSTOM_STYLE_ID = 165;
    private StyleSheetDocument doc;
    private ThemesTable theme;

    public StylesTable() {
        this.doc = StyleSheetDocument.Factory.newInstance();
        this.doc.addNewStyleSheet();
        this.initialize();
    }

    public StylesTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public ThemesTable getTheme() {
        return this.theme;
    }

    public void setTheme(ThemesTable theme) {
        this.theme = theme;
        for (XSSFFont font : this.fonts) {
            font.setThemesTable(theme);
        }
        for (XSSFCellBorder border : this.borders) {
            border.setThemesTable(theme);
        }
    }

    protected void readFrom(InputStream is) throws IOException {
        try {
            CTDxfs styleDxfs;
            CTCellStyleXfs cellStyleXfs;
            CTCellXfs cellXfs;
            CTBorders ctborders;
            CTFills ctfills;
            CTFonts ctfonts;
            this.doc = StyleSheetDocument.Factory.parse((InputStream)is);
            CTStylesheet styleSheet = this.doc.getStyleSheet();
            CTNumFmts ctfmts = styleSheet.getNumFmts();
            if (ctfmts != null) {
                for (CTNumFmt nfmt : ctfmts.getNumFmtArray()) {
                    this.numberFormats.put((int)nfmt.getNumFmtId(), nfmt.getFormatCode());
                }
            }
            if ((ctfonts = styleSheet.getFonts()) != null) {
                int idx = 0;
                CTFont[] arr$ = ctfonts.getFontArray();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    CTFont font = arr$[i$];
                    XSSFFont f = new XSSFFont(font, idx);
                    this.fonts.add(f);
                    ++idx;
                }
            }
            if ((ctfills = styleSheet.getFills()) != null) {
                for (CTFill fill : ctfills.getFillArray()) {
                    this.fills.add(new XSSFCellFill(fill));
                }
            }
            if ((ctborders = styleSheet.getBorders()) != null) {
                for (CTBorder border : ctborders.getBorderArray()) {
                    this.borders.add(new XSSFCellBorder(border));
                }
            }
            if ((cellXfs = styleSheet.getCellXfs()) != null) {
                this.xfs.addAll(Arrays.asList(cellXfs.getXfArray()));
            }
            if ((cellStyleXfs = styleSheet.getCellStyleXfs()) != null) {
                this.styleXfs.addAll(Arrays.asList(cellStyleXfs.getXfArray()));
            }
            if ((styleDxfs = styleSheet.getDxfs()) != null) {
                this.dxfs.addAll(Arrays.asList(styleDxfs.getDxfArray()));
            }
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public String getNumberFormatAt(int idx) {
        return this.numberFormats.get(idx);
    }

    public int putNumberFormat(String fmt) {
        if (this.numberFormats.containsValue(fmt)) {
            for (Integer key : this.numberFormats.keySet()) {
                if (!this.numberFormats.get(key).equals(fmt)) continue;
                return key;
            }
            throw new IllegalStateException("Found the format, but couldn't figure out where - should never happen!");
        }
        int newKey = 165;
        while (this.numberFormats.containsKey(newKey)) {
            ++newKey;
        }
        this.numberFormats.put(newKey, fmt);
        return newKey;
    }

    public XSSFFont getFontAt(int idx) {
        return this.fonts.get(idx);
    }

    public int putFont(XSSFFont font, boolean forceRegistration) {
        int idx = -1;
        if (!forceRegistration) {
            idx = this.fonts.indexOf(font);
        }
        if (idx != -1) {
            return idx;
        }
        idx = this.fonts.size();
        this.fonts.add(font);
        return idx;
    }

    public int putFont(XSSFFont font) {
        return this.putFont(font, false);
    }

    public XSSFCellStyle getStyleAt(int idx) {
        int styleXfId = 0;
        if (this.xfs.get(idx).getXfId() > 0L) {
            styleXfId = (int)this.xfs.get(idx).getXfId();
        }
        return new XSSFCellStyle(idx, styleXfId, this, this.theme);
    }

    public int putStyle(XSSFCellStyle style) {
        CTXf mainXF = style.getCoreXf();
        if (!this.xfs.contains(mainXF)) {
            this.xfs.add(mainXF);
        }
        return this.xfs.indexOf(mainXF);
    }

    public XSSFCellBorder getBorderAt(int idx) {
        return this.borders.get(idx);
    }

    public int putBorder(XSSFCellBorder border) {
        int idx = this.borders.indexOf(border);
        if (idx != -1) {
            return idx;
        }
        this.borders.add(border);
        border.setThemesTable(this.theme);
        return this.borders.size() - 1;
    }

    public XSSFCellFill getFillAt(int idx) {
        return this.fills.get(idx);
    }

    public List<XSSFCellBorder> getBorders() {
        return this.borders;
    }

    public List<XSSFCellFill> getFills() {
        return this.fills;
    }

    public List<XSSFFont> getFonts() {
        return this.fonts;
    }

    public Map<Integer, String> getNumberFormats() {
        return this.numberFormats;
    }

    public int putFill(XSSFCellFill fill) {
        int idx = this.fills.indexOf(fill);
        if (idx != -1) {
            return idx;
        }
        this.fills.add(fill);
        return this.fills.size() - 1;
    }

    public CTXf getCellXfAt(int idx) {
        return this.xfs.get(idx);
    }

    public int putCellXf(CTXf cellXf) {
        this.xfs.add(cellXf);
        return this.xfs.size();
    }

    public void replaceCellXfAt(int idx, CTXf cellXf) {
        this.xfs.set(idx, cellXf);
    }

    public CTXf getCellStyleXfAt(int idx) {
        return idx < this.styleXfs.size() ? this.styleXfs.get(idx) : null;
    }

    public int putCellStyleXf(CTXf cellStyleXf) {
        this.styleXfs.add(cellStyleXf);
        return this.styleXfs.size();
    }

    public void replaceCellStyleXfAt(int idx, CTXf cellStyleXf) {
        this.styleXfs.set(idx, cellStyleXf);
    }

    public int getNumCellStyles() {
        return this.xfs.size();
    }

    public int _getNumberFormatSize() {
        return this.numberFormats.size();
    }

    public int _getXfsSize() {
        return this.xfs.size();
    }

    public int _getStyleXfsSize() {
        return this.styleXfs.size();
    }

    public CTStylesheet getCTStylesheet() {
        return this.doc.getStyleSheet();
    }

    public int _getDXfsSize() {
        return this.dxfs.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        XmlOptions options = new XmlOptions(DEFAULT_XML_OPTIONS);
        CTStylesheet styleSheet = this.doc.getStyleSheet();
        CTNumFmts formats = CTNumFmts.Factory.newInstance();
        formats.setCount((long)this.numberFormats.size());
        for (Map.Entry<Integer, String> fmt : this.numberFormats.entrySet()) {
            CTNumFmt ctFmt = formats.addNewNumFmt();
            ctFmt.setNumFmtId((long)fmt.getKey().intValue());
            ctFmt.setFormatCode(fmt.getValue());
        }
        styleSheet.setNumFmts(formats);
        CTFonts ctFonts = styleSheet.getFonts();
        if (ctFonts == null) {
            ctFonts = CTFonts.Factory.newInstance();
        }
        ctFonts.setCount((long)this.fonts.size());
        CTFont[] ctfnt = new CTFont[this.fonts.size()];
        int idx = 0;
        for (XSSFFont f : this.fonts) {
            ctfnt[idx++] = f.getCTFont();
        }
        ctFonts.setFontArray(ctfnt);
        styleSheet.setFonts(ctFonts);
        CTFills ctFills = styleSheet.getFills();
        if (ctFills == null) {
            ctFills = CTFills.Factory.newInstance();
        }
        ctFills.setCount((long)this.fills.size());
        CTFill[] ctf = new CTFill[this.fills.size()];
        idx = 0;
        for (XSSFCellFill f : this.fills) {
            ctf[idx++] = f.getCTFill();
        }
        ctFills.setFillArray(ctf);
        styleSheet.setFills(ctFills);
        CTBorders ctBorders = styleSheet.getBorders();
        if (ctBorders == null) {
            ctBorders = CTBorders.Factory.newInstance();
        }
        ctBorders.setCount((long)this.borders.size());
        CTBorder[] ctb = new CTBorder[this.borders.size()];
        idx = 0;
        for (XSSFCellBorder b : this.borders) {
            ctb[idx++] = b.getCTBorder();
        }
        ctBorders.setBorderArray(ctb);
        styleSheet.setBorders(ctBorders);
        if (this.xfs.size() > 0) {
            CTCellXfs ctXfs = styleSheet.getCellXfs();
            if (ctXfs == null) {
                ctXfs = CTCellXfs.Factory.newInstance();
            }
            ctXfs.setCount((long)this.xfs.size());
            ctXfs.setXfArray(this.xfs.toArray(new CTXf[this.xfs.size()]));
            styleSheet.setCellXfs(ctXfs);
        }
        if (this.styleXfs.size() > 0) {
            CTCellStyleXfs ctSXfs = styleSheet.getCellStyleXfs();
            if (ctSXfs == null) {
                ctSXfs = CTCellStyleXfs.Factory.newInstance();
            }
            ctSXfs.setCount((long)this.styleXfs.size());
            ctSXfs.setXfArray(this.styleXfs.toArray(new CTXf[this.styleXfs.size()]));
            styleSheet.setCellStyleXfs(ctSXfs);
        }
        if (this.dxfs.size() > 0) {
            CTDxfs ctDxfs = styleSheet.getDxfs();
            if (ctDxfs == null) {
                ctDxfs = CTDxfs.Factory.newInstance();
            }
            ctDxfs.setCount((long)this.dxfs.size());
            ctDxfs.setDxfArray(this.dxfs.toArray(new CTDxf[this.dxfs.size()]));
            styleSheet.setDxfs(ctDxfs);
        }
        this.doc.save(out, options);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    private void initialize() {
        XSSFFont xssfFont = StylesTable.createDefaultFont();
        this.fonts.add(xssfFont);
        CTFill[] ctFill = StylesTable.createDefaultFills();
        this.fills.add(new XSSFCellFill(ctFill[0]));
        this.fills.add(new XSSFCellFill(ctFill[1]));
        CTBorder ctBorder = StylesTable.createDefaultBorder();
        this.borders.add(new XSSFCellBorder(ctBorder));
        CTXf styleXf = StylesTable.createDefaultXf();
        this.styleXfs.add(styleXf);
        CTXf xf = StylesTable.createDefaultXf();
        xf.setXfId(0L);
        this.xfs.add(xf);
    }

    private static CTXf createDefaultXf() {
        CTXf ctXf = CTXf.Factory.newInstance();
        ctXf.setNumFmtId(0L);
        ctXf.setFontId(0L);
        ctXf.setFillId(0L);
        ctXf.setBorderId(0L);
        return ctXf;
    }

    private static CTBorder createDefaultBorder() {
        CTBorder ctBorder = CTBorder.Factory.newInstance();
        ctBorder.addNewBottom();
        ctBorder.addNewTop();
        ctBorder.addNewLeft();
        ctBorder.addNewRight();
        ctBorder.addNewDiagonal();
        return ctBorder;
    }

    private static CTFill[] createDefaultFills() {
        CTFill[] ctFill = new CTFill[]{CTFill.Factory.newInstance(), CTFill.Factory.newInstance()};
        ctFill[0].addNewPatternFill().setPatternType(STPatternType.NONE);
        ctFill[1].addNewPatternFill().setPatternType(STPatternType.DARK_GRAY);
        return ctFill;
    }

    private static XSSFFont createDefaultFont() {
        CTFont ctFont = CTFont.Factory.newInstance();
        XSSFFont xssfFont = new XSSFFont(ctFont, 0);
        xssfFont.setFontHeightInPoints((short)11);
        xssfFont.setColor(XSSFFont.DEFAULT_FONT_COLOR);
        xssfFont.setFontName("Calibri");
        xssfFont.setFamily(FontFamily.SWISS);
        xssfFont.setScheme(FontScheme.MINOR);
        return xssfFont;
    }

    public CTDxf getDxfAt(int idx) {
        return this.dxfs.get(idx);
    }

    public int putDxf(CTDxf dxf) {
        this.dxfs.add(dxf);
        return this.dxfs.size();
    }

    public XSSFCellStyle createCellStyle() {
        CTXf xf = CTXf.Factory.newInstance();
        xf.setNumFmtId(0L);
        xf.setFontId(0L);
        xf.setFillId(0L);
        xf.setBorderId(0L);
        xf.setXfId(0L);
        int xfSize = this.styleXfs.size();
        int indexXf = this.putCellXf(xf);
        return new XSSFCellStyle(indexXf - 1, xfSize - 1, this, this.theme);
    }

    public XSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (XSSFFont font : this.fonts) {
            if (font.getBoldweight() != boldWeight || font.getColor() != color || font.getFontHeight() != fontHeight || !font.getFontName().equals(name) || font.getItalic() != italic || font.getStrikeout() != strikeout || font.getTypeOffset() != typeOffset || font.getUnderline() != underline) continue;
            return font;
        }
        return null;
    }
}

