/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.agile;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionHeader;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;

public class AgileDecryptor
extends Decryptor {
    private final AgileEncryptionInfoBuilder builder;
    private long _length = -1L;
    protected static final byte[] kVerifierInputBlock = new byte[]{-2, -89, -46, 118, 59, 75, -98, 121};
    protected static final byte[] kHashedVerifierBlock = new byte[]{-41, -86, 15, 109, 48, 97, 52, 78};
    protected static final byte[] kCryptoKeyBlock = new byte[]{20, 110, 11, -25, -85, -84, -48, -42};
    protected static final byte[] kIntegrityKeyBlock = new byte[]{95, -78, -83, 1, 12, -71, -31, -10};
    protected static final byte[] kIntegrityValueBlock = new byte[]{-96, 103, 127, 2, -78, 44, -124, 51};

    protected AgileDecryptor(AgileEncryptionInfoBuilder builder) {
        super(builder.getInfo());
        this.builder = builder;
    }

    public boolean verifyPassword(String password) throws GeneralSecurityException {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        AgileEncryptionHeader header = this.builder.getHeader();
        HashAlgorithm hashAlgo = header.getHashAlgorithmEx();
        CipherAlgorithm cipherAlgo = header.getCipherAlgorithm();
        int blockSize = header.getBlockSize();
        int keySize = header.getKeySize() / 8;
        byte[] pwHash = CryptoFunctions.hashPassword((String)password, (HashAlgorithm)ver.getHashAlgorithm(), (byte[])ver.getSalt(), (int)ver.getSpinCount());
        byte[] verfierInputEnc = AgileDecryptor.hashInput(this.builder, pwHash, kVerifierInputBlock, ver.getEncryptedVerifier(), 2);
        this.setVerifier(verfierInputEnc);
        MessageDigest hashMD = CryptoFunctions.getMessageDigest((HashAlgorithm)hashAlgo);
        byte[] verifierHash = hashMD.digest(verfierInputEnc);
        byte[] verifierHashDec = AgileDecryptor.hashInput(this.builder, pwHash, kHashedVerifierBlock, ver.getEncryptedVerifierHash(), 2);
        verifierHashDec = CryptoFunctions.getBlock0((byte[])verifierHashDec, (int)hashAlgo.hashSize);
        byte[] keyspec = AgileDecryptor.hashInput(this.builder, pwHash, kCryptoKeyBlock, ver.getEncryptedKey(), 2);
        keyspec = CryptoFunctions.getBlock0((byte[])keyspec, (int)keySize);
        SecretKeySpec secretKey = new SecretKeySpec(keyspec, ver.getCipherAlgorithm().jceId);
        byte[] vec = CryptoFunctions.generateIv((HashAlgorithm)hashAlgo, (byte[])header.getKeySalt(), (byte[])kIntegrityKeyBlock, (int)blockSize);
        Cipher cipher = CryptoFunctions.getCipher((SecretKey)secretKey, (CipherAlgorithm)cipherAlgo, (ChainingMode)ver.getChainingMode(), (byte[])vec, (int)2);
        byte[] hmacKey = cipher.doFinal(header.getEncryptedHmacKey());
        hmacKey = CryptoFunctions.getBlock0((byte[])hmacKey, (int)hashAlgo.hashSize);
        vec = CryptoFunctions.generateIv((HashAlgorithm)hashAlgo, (byte[])header.getKeySalt(), (byte[])kIntegrityValueBlock, (int)blockSize);
        cipher = CryptoFunctions.getCipher((SecretKey)secretKey, (CipherAlgorithm)cipherAlgo, (ChainingMode)ver.getChainingMode(), (byte[])vec, (int)2);
        byte[] hmacValue = cipher.doFinal(header.getEncryptedHmacValue());
        hmacValue = CryptoFunctions.getBlock0((byte[])hmacValue, (int)hashAlgo.hashSize);
        if (Arrays.equals(verifierHashDec, verifierHash)) {
            this.setSecretKey(secretKey);
            this.setIntegrityHmacKey(hmacKey);
            this.setIntegrityHmacValue(hmacValue);
            return true;
        }
        return false;
    }

    public boolean verifyPassword(KeyPair keyPair, X509Certificate x509) throws GeneralSecurityException {
        AgileEncryptionVerifier ver = this.builder.getVerifier();
        AgileEncryptionHeader header = this.builder.getHeader();
        HashAlgorithm hashAlgo = header.getHashAlgorithmEx();
        CipherAlgorithm cipherAlgo = header.getCipherAlgorithm();
        int blockSize = header.getBlockSize();
        AgileEncryptionVerifier.AgileCertificateEntry ace = null;
        for (AgileEncryptionVerifier.AgileCertificateEntry aceEntry : ver.getCertificates()) {
            if (!x509.equals(aceEntry.x509)) continue;
            ace = aceEntry;
            break;
        }
        if (ace == null) {
            return false;
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, keyPair.getPrivate());
        byte[] keyspec = cipher.doFinal(ace.encryptedKey);
        SecretKeySpec secretKey = new SecretKeySpec(keyspec, ver.getCipherAlgorithm().jceId);
        Mac x509Hmac = CryptoFunctions.getMac((HashAlgorithm)hashAlgo);
        x509Hmac.init(secretKey);
        byte[] certVerifier = x509Hmac.doFinal(ace.x509.getEncoded());
        byte[] vec = CryptoFunctions.generateIv((HashAlgorithm)hashAlgo, (byte[])header.getKeySalt(), (byte[])kIntegrityKeyBlock, (int)blockSize);
        cipher = CryptoFunctions.getCipher((SecretKey)secretKey, (CipherAlgorithm)cipherAlgo, (ChainingMode)ver.getChainingMode(), (byte[])vec, (int)2);
        byte[] hmacKey = cipher.doFinal(header.getEncryptedHmacKey());
        hmacKey = CryptoFunctions.getBlock0((byte[])hmacKey, (int)hashAlgo.hashSize);
        vec = CryptoFunctions.generateIv((HashAlgorithm)hashAlgo, (byte[])header.getKeySalt(), (byte[])kIntegrityValueBlock, (int)blockSize);
        cipher = CryptoFunctions.getCipher((SecretKey)secretKey, (CipherAlgorithm)cipherAlgo, (ChainingMode)ver.getChainingMode(), (byte[])vec, (int)2);
        byte[] hmacValue = cipher.doFinal(header.getEncryptedHmacValue());
        hmacValue = CryptoFunctions.getBlock0((byte[])hmacValue, (int)hashAlgo.hashSize);
        if (Arrays.equals(ace.certVerifier, certVerifier)) {
            this.setSecretKey(secretKey);
            this.setIntegrityHmacKey(hmacKey);
            this.setIntegrityHmacValue(hmacValue);
            return true;
        }
        return false;
    }

    protected static int getNextBlockSize(int inputLen, int blockSize) {
        int fillSize;
        for (fillSize = blockSize; fillSize < inputLen; fillSize += blockSize) {
        }
        return fillSize;
    }

    protected static byte[] hashInput(AgileEncryptionInfoBuilder builder, byte[] pwHash, byte[] blockKey, byte[] inputKey, int cipherMode) {
        AgileEncryptionVerifier ver = builder.getVerifier();
        int keySize = builder.getDecryptor().getKeySizeInBytes();
        int blockSize = builder.getDecryptor().getBlockSizeInBytes();
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        byte[] salt = ver.getSalt();
        byte[] intermedKey = CryptoFunctions.generateKey((byte[])pwHash, (HashAlgorithm)hashAlgo, (byte[])blockKey, (int)keySize);
        SecretKeySpec skey = new SecretKeySpec(intermedKey, ver.getCipherAlgorithm().jceId);
        byte[] iv = CryptoFunctions.generateIv((HashAlgorithm)hashAlgo, (byte[])salt, null, (int)blockSize);
        Cipher cipher = CryptoFunctions.getCipher((SecretKey)skey, (CipherAlgorithm)ver.getCipherAlgorithm(), (ChainingMode)ver.getChainingMode(), (byte[])iv, (int)cipherMode);
        try {
            inputKey = CryptoFunctions.getBlock0((byte[])inputKey, (int)AgileDecryptor.getNextBlockSize(inputKey.length, blockSize));
            byte[] hashFinal = cipher.doFinal(inputKey);
            return hashFinal;
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedDocumentException((Throwable)e);
        }
    }

    public InputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptedPackage");
        this._length = dis.readLong();
        ChunkedCipherInputStream cipherStream = new ChunkedCipherInputStream(dis, this._length);
        return cipherStream;
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("EcmaDecryptor.getDataStream() was not called");
        }
        return this._length;
    }

    protected int getBlockSizeInBytes() {
        return this.info.getHeader().getBlockSize();
    }

    protected int getKeySizeInBytes() {
        return this.info.getHeader().getKeySize() / 8;
    }

    private class ChunkedCipherInputStream
    extends InputStream {
        private int _lastIndex = 0;
        private long _pos = 0L;
        private final long _size;
        private final InputStream _stream;
        private byte[] _chunk;
        private Cipher _cipher;

        public ChunkedCipherInputStream(DocumentInputStream stream, long size) throws GeneralSecurityException {
            EncryptionHeader header = AgileDecryptor.this.info.getHeader();
            this._size = size;
            this._stream = stream;
            this._cipher = CryptoFunctions.getCipher((SecretKey)AgileDecryptor.this.getSecretKey(), (CipherAlgorithm)header.getCipherAlgorithm(), (ChainingMode)header.getChainingMode(), (byte[])header.getKeySalt(), (int)2);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == 1) {
                return b[0];
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int total = 0;
            if (this.available() <= 0) {
                return -1;
            }
            while (len > 0) {
                if (this._chunk == null) {
                    try {
                        this._chunk = this.nextChunk();
                    }
                    catch (GeneralSecurityException e) {
                        throw new EncryptedDocumentException(e.getMessage());
                    }
                }
                int count = (int)(4096L - (this._pos & 0xFFFL));
                int avail = this.available();
                if (avail == 0) {
                    return total;
                }
                count = Math.min(avail, Math.min(count, len));
                System.arraycopy(this._chunk, (int)(this._pos & 0xFFFL), b, off, count);
                off += count;
                len -= count;
                this._pos += (long)count;
                if ((this._pos & 0xFFFL) == 0L) {
                    this._chunk = null;
                }
                total += count;
            }
            return total;
        }

        @Override
        public long skip(long n) throws IOException {
            long start = this._pos;
            long skip = Math.min((long)this.available(), n);
            if (((this._pos + skip ^ start) & 0xFFFFFFFFFFFFF000L) != 0L) {
                this._chunk = null;
            }
            this._pos += skip;
            return skip;
        }

        @Override
        public int available() throws IOException {
            return (int)(this._size - this._pos);
        }

        @Override
        public void close() throws IOException {
            this._stream.close();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        private byte[] nextChunk() throws GeneralSecurityException, IOException {
            int index = (int)(this._pos >> 12);
            byte[] blockKey = new byte[4];
            LittleEndian.putInt((byte[])blockKey, (int)0, (int)index);
            EncryptionHeader header = AgileDecryptor.this.info.getHeader();
            byte[] iv = CryptoFunctions.generateIv((HashAlgorithm)header.getHashAlgorithmEx(), (byte[])header.getKeySalt(), (byte[])blockKey, (int)AgileDecryptor.this.getBlockSizeInBytes());
            AlgorithmParameterSpec aps = header.getCipherAlgorithm() == CipherAlgorithm.rc2 ? new RC2ParameterSpec(AgileDecryptor.this.getSecretKey().getEncoded().length * 8, iv) : new IvParameterSpec(iv);
            this._cipher.init(2, (Key)AgileDecryptor.this.getSecretKey(), aps);
            if (this._lastIndex != index) {
                this._stream.skip(index - this._lastIndex << 12);
            }
            byte[] block = new byte[Math.min(this._stream.available(), 4096)];
            this._stream.read(block);
            this._lastIndex = index + 1;
            return this._cipher.doFinal(block);
        }
    }
}

