% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xDefineOntology.r
\name{xDefineOntology}
\alias{xDefineOntology}
\title{Function to define ontology and its annotations}
\usage{
xDefineOntology(ontology = c(NA, "GOBP", "GOMF", "GOCC", "PSG", "PS",
"PS2",
"SF", "Pfam", "DO", "HPPA", "HPMI", "HPCM", "HPMA", "MP", "EF",
"MsigdbH",
"MsigdbC1", "MsigdbC2CGP", "MsigdbC2CPall", "MsigdbC2CP",
"MsigdbC2KEGG",
"MsigdbC2REACTOME", "MsigdbC2BIOCARTA", "MsigdbC3TFT", "MsigdbC3MIR",
"MsigdbC4CGN", "MsigdbC4CM", "MsigdbC5BP", "MsigdbC5MF", "MsigdbC5CC",
"MsigdbC6", "MsigdbC7", "DGIdb", "GTExV4", "GTExV6p", "GTExV7",
"CreedsDisease", "CreedsDiseaseUP", "CreedsDiseaseDN", "CreedsDrug",
"CreedsDrugUP", "CreedsDrugDN", "CreedsGene", "CreedsGeneUP",
"CreedsGeneDN", "KEGG", "KEGGmetabolism", "KEGGgenetic",
"KEGGenvironmental",
"KEGGcellular", "KEGGorganismal", "KEGGdisease", "REACTOME",
"REACTOME_ImmuneSystem", "REACTOME_SignalTransduction", "CGL",
"SIFTS2GOBP",
"SIFTS2GOMF", "SIFTS2GOCC"), verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{ontology}{the ontology supported currently. It can be "GOBP" for
Gene Ontology Biological Process, "GOMF" for Gene Ontology Molecular
Function, "GOCC" for Gene Ontology Cellular Component, "PSG" for
phylostratigraphy (phylostratific age), "PS" for sTOL-based
phylostratific age information, "PS2" for the collapsed PS version
(inferred ancestors being collapsed into one with the known taxonomy
information), "SF" for SCOP domain superfamilies, "Pfam" for Pfam
domain families, "DO" for Disease Ontology, "HPPA" for Human Phenotype
Phenotypic Abnormality, "HPMI" for Human Phenotype Mode of Inheritance,
"HPCM" for Human Phenotype Clinical Modifier, "HPMA" for Human
Phenotype Mortality Aging, "MP" for Mammalian Phenotype, "EF" for
Experimental Factor Ontology (used to annotate GWAS Catalog genes),
Drug-Gene Interaction database ("DGIdb") for druggable categories,
tissue-specific eQTL-containing genes from GTEx ("GTExV4", "GTExV6p"
and "GTExV7"), crowd extracted expression of differential signatures
from CREEDS ("CreedsDisease", "CreedsDiseaseUP", "CreedsDiseaseDN",
"CreedsDrug", "CreedsDrugUP", "CreedsDrugDN", "CreedsGene",
"CreedsGeneUP" and "CreedsGeneDN"), KEGG pathways (including 'KEGG' for
all, 'KEGGmetabolism' for 'Metabolism' pathways, 'KEGGgenetic' for
'Genetic Information Processing' pathways, 'KEGGenvironmental' for
'Environmental Information Processing' pathways, 'KEGGcellular' for
'Cellular Processes' pathways, 'KEGGorganismal' for 'Organismal
Systems' pathways, and 'KEGGdisease' for 'Human Diseases' pathways),
'REACTOME' for REACTOME pathways or 'REACTOME_x' for its sub-ontologies
(where x can be 'CellCellCommunication', 'CellCycle',
'CellularResponsesToExternalStimuli', 'ChromatinOrganization',
'CircadianClock', 'DevelopmentalBiology', 'DigestionAndAbsorption',
'Disease', 'DNARepair', 'DNAReplication',
'ExtracellularMatrixOrganization', 'GeneExpression(Transcription)',
'Hemostasis', 'ImmuneSystem', 'Metabolism', 'MetabolismOfProteins',
'MetabolismOfRNA', 'Mitophagy', 'MuscleContraction', 'NeuronalSystem',
'OrganelleBiogenesisAndMaintenance', 'ProgrammedCellDeath',
'Reproduction', 'SignalTransduction', 'TransportOfSmallMolecules',
'VesicleMediatedTransport'), and the molecular signatures database
(Msigdb, including "MsigdbH", "MsigdbC1", "MsigdbC2CGP",
"MsigdbC2CPall", "MsigdbC2CP", "MsigdbC2KEGG", "MsigdbC2REACTOME",
"MsigdbC2BIOCARTA", "MsigdbC3TFT", "MsigdbC3MIR", "MsigdbC4CGN",
"MsigdbC4CM", "MsigdbC5BP", "MsigdbC5MF", "MsigdbC5CC", "MsigdbC6",
"MsigdbC7"), and the SIFTS database ("SIFTS2GOBP" for Gene Ontology
Biological Process, "SIFTS2GOMF" for Gene Ontology Molecular Function,
"SIFTS2GOCC" for Gene Ontology Cellular Component)}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
an object of class "aOnto", a list with two components (an igraph
object 'g' and a list 'anno')
}
\description{
\code{xDefineOntology} is supposed to define ontology and its
annotations. It returns an object of class "aOnto".
}
\note{
none
}
\examples{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

\dontrun{
aOnto <- xDefineOntology("HPPA", RData.location=RData.location)
aOnto <- xDefineOntology("REACTOME_ImmuneSystem",
RData.location=RData.location)
aOnto <- xDefineOntology("CGL", RData.location=RData.location)
}
}
\seealso{
\code{\link{xRDataLoader}}
}
