% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xVolcano.r
\name{xVolcano}
\alias{xVolcano}
\title{Function to draw a volcano plot}
\usage{
xVolcano(data, column.lfc = "lfc", column.fdr = "fdr", cutoff.lfc = 1,
cutoff.fdr = 0.05, colors = c("#EEEEEE", "darkgrey", "pink", "red"),
column.label = NULL, top = 10, top.direction = c("both", "up", "down"),
label.size = 2, label.color = "black", label.alpha = 0.8,
label.padding = 0.5, label.arrow = 0.01, label.force = 0.5,
xlim = NULL, ylim = NULL, y.scale = c("normal", "log"),
xlab = expression(log[2]("fold change")),
ylab = expression(-log[10]("FDR")), font.family = "sans",
signature = TRUE)
}
\arguments{
\item{data}{a data frame}

\item{column.lfc}{a character specifying 'lfc' column (log2-transformed
fold change)}

\item{column.fdr}{a character specifying 'fdr' column}

\item{cutoff.lfc}{a numeric defining 'lfc' cutoff. By default, it is 1
(at least 2-fold changes)}

\item{cutoff.fdr}{a numeric defining 'fdr' cutoff. By default, it is
0.05}

\item{colors}{a 4-element vector for color-coded points. By default, it
is c("#EEEEEE","darkgrey","pink","red")}

\item{column.label}{a character specifying 'label' column}

\item{top}{an integer specifying the number of the top points for
labellings}

\item{top.direction}{the direction (up- and down-regulated) of the top
points. It can be one of 'both' (up- and down-regulated), 'up'
(up-regulated only) and 'down' (down-regulated only)}

\item{label.size}{the label size}

\item{label.color}{the label color}

\item{label.alpha}{the 0-1 value specifying transparency of labelling}

\item{label.padding}{the padding around the labeled}

\item{label.arrow}{the arrow pointing to the labeled}

\item{label.force}{the repelling force between overlapping labels}

\item{xlim}{the limits in the x-axis}

\item{ylim}{the limits in the y-axis}

\item{y.scale}{how to transform the y scale. It can be "normal" for no
transformation, and "log" for log-based transformation}

\item{xlab}{the x labelling. By default, it is expression(log[2]("fold
change"))}

\item{ylab}{the y labelling. By default, it is
expression(-log[10]("FDR"))}

\item{font.family}{the font family for texts}

\item{signature}{logical to indicate whether the signature is assigned
to the plot caption. By default, it sets TRUE}
}
\value{
a ggplot object
}
\description{
\code{xVolcano} is supposed to draw a volcano plot
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev/"
}
}
\seealso{
\code{\link{xVolcano}}
}
