% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSymbol2GeneID.r
\name{xSymbol2GeneID}
\alias{xSymbol2GeneID}
\title{Function to convert gene symbols to entrez geneid}
\usage{
xSymbol2GeneID(data, check.symbol.identity = F, details = F, verbose =
T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{an input vector containing gene symbols}

\item{check.symbol.identity}{logical to indicate whether to match the
input data via Synonyms for those unmatchable by official gene symbols.
By default, it sets to false}

\item{details}{logical to indicate whether to result in a data frame
(in great details). By default, it sets to false}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a vector containing entrez geneid with 'NA' for the unmatched if
(details set to false); otherwise, a data frame is returned
}
\description{
\code{xSymbol2GeneID} is supposed to convert gene symbols to entrez
geneid.
}
\note{
If a symbol mapped many times, the one assiged as the "protein-coding"
type of gene is preferred.
}
\examples{
\dontrun{
# Load the library
library(XGR)

# a) provide the input Genes of interest (eg 100 randomly chosen human genes)
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg')
Symbol <- as.character(sample(org.Hs.eg$gene_info$Symbol, 100))
Symbol

# b) convert into GeneID
GeneID <- xSymbol2GeneID(Symbol)

# c) convert into a data frame
df <- xSymbol2GeneID(Symbol, details=TRUE)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xSocialiserGenes}}
}
