% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worm_clustering.R
\name{worm_clustering,WormTensor-method}
\alias{worm_clustering,WormTensor-method}
\title{Generates clustering result
A clustering result is generated from a membership tensor.}
\usage{
\S4method{worm_clustering}{WormTensor}(
  object,
  algorithm = c("MCMI", "OINDSCAL", "CSPA"),
  num.iter = 30,
  thr = 1e-10,
  verbose = FALSE
)
}
\arguments{
\item{object}{WormTensor object with a membership tensor}

\item{algorithm}{Clustering methods}

\item{num.iter}{The upper limit of iterations (Default value is 30)}

\item{thr}{The lower limit of relative change in estimates
(Default value is 1E-10)}

\item{verbose}{Control message}
}
\value{
WormTensor object with a clustering result added
}
\description{
Generates clustering result
A clustering result is generated from a membership tensor.
}
\examples{
\donttest{
    # Pipe Operation
    worm_download("Euclid", qc = "WARN")$Ds |>
        as_worm_tensor() |>
            worm_membership(k = 6) -> object
    worm_clustering(object, verbose = TRUE) -> ob_mcmi
    worm_clustering(object, algorithm = "OINDSCAL", verbose = TRUE) -> ob_oind
    worm_clustering(object, algorithm = "CSPA", verbose = TRUE) -> ob_cspa
}
}
