% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gets.R
\name{get_item}
\alias{get_item}
\alias{get_property}
\title{Retrieve specific Wikidata items or properties}
\usage{
get_item(id, ...)

get_property(id, ...)
}
\arguments{
\item{id}{the ID number of the item or property you're looking for. This can be in
various formats; either a numeric value ("200"), the full name ("Q200") or
even with an included namespace ("Property:P10") - the function will format
it appropriately.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
\code{get_item} and \code{get_property} allow you to retrieve the data associated
with individual Wikidata items and properties, respectively. As with
other \code{WikidataR} code, custom print methods are available; use \code{\link{str}}
to manipulate and see the underlying structure of the data.
}
\examples{

#Retrieve a specific item
adams_metadata <- get_item("42")

#Retrieve a specific property
object_is_child <- get_property("P40")

}
\seealso{
\code{\link{get_random}} for selecting a random item or property,
or \code{\link{find_item}} for using search functionality to pull out
item or property IDs where the descriptions or aliases match a particular
search term.
}

