% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dxWienerDens.R
\name{gradWienerPDF}
\alias{gradWienerPDF}
\title{Gradient of the first-passage time probability density function}
\usage{
gradWienerPDF(
  t,
  response,
  a,
  v,
  w,
  t0,
  sv,
  sw,
  st0,
  precision = NULL,
  K = NULL,
  n.threads = FALSE
)
}
\arguments{
\item{t}{First-passage time. Numeric vector.}

\item{response}{Response boundary. Character vector with \code{"upper"} and \code{"lower"} as possible values. Alternatively a numeric vector with
\code{1}=lower and \code{2}=upper.}

\item{a}{Upper barrier. Numeric vector.}

\item{v}{Drift rate. Numeric vector.}

\item{w}{Relative starting point. Numeric vector.}

\item{t0}{Non-decision time. Numeric vector}

\item{sv}{Inter-trial variability of drift rate. Numeric vector. Standard deviation of a normal distribution \code{N(v, sv)}.}

\item{sw}{Inter-trial variability of relative starting point. Numeric vector. Range of uniform distribution \code{U(w-0.5*sw, w+0.5*sw)}.}

\item{st0}{Inter-trial variability of non-decision time. Numeric vector. Range of uniform distribution \code{U(t0, t0+st0)}.}

\item{precision}{Optional numeric value. Precision of the partial derivative. Numeric value. Default is \code{NULL}, which takes default value 1e-12.}

\item{K}{Optional. Number of iterations to calculate the infinite sums. Numeric value (integer). Default is \code{NULL}.
\itemize{
  \item \code{precision = NULL} and \code{K = NULL}: Default \code{precision = 1e-12} used to calculate internal K.
  \item \code{precision != NULL} and \code{K = NULL}: \code{precision} is used to calculate internal K,
  \item \code{precision = NULL} and \code{K != NULL}: \code{K} is used as internal K,
  \item \code{precision != NULL} and \code{K != NULL}: if internal K calculated through \code{precision} is smaller than \code{K}, \code{K} is used.
}
We recommend using either default (\code{precision = K = NULL}) or only \code{precision}.}

\item{n.threads}{Optional numerical or logical value. Number of threads to use. If not provided (or 1 or \code{FALSE}) parallelization is not used. If set to \code{TRUE} then all available threads are used.}
}
\value{
A list of the class \code{Diffusion_deriv} containing
  \itemize{
    \item \code{deriv}: the derivatives of the PDF with respect to a, v, w, t0, sv, sw, and st0,
    \item \code{call}: the function call.
  }
}
\description{
Calculate the gradient of the first-passage time probability density function.
}
\examples{
gradWienerPDF(t = 1.2, response = "upper", a = 1.1, v = 13, w = .6,
              t0 = .3, sv = .1, sw = .1, st0 = .1)
}
\author{
Raphael Hartmann
}
