% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_contour.R
\name{plotly_contour}
\alias{plotly_contour}
\title{Interactive Contour Plot.}
\usage{
plotly_contour(
  wblr_obj,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  col = NULL,
  signif = NULL,
  grid = NULL,
  gridcol = NULL
)
}
\arguments{
\item{wblr_obj}{An object of class 'wblr'.}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{col}{Color of the model fit and confidence bounds}

\item{signif}{Significant digits of results}

\item{grid}{Show grid (TRUE) or hide grid (FALSE).}

\item{gridcol}{Color of the grid.}
}
\value{
The function returns no value.
}
\description{
Interactive Contour Plot.
}
\examples{
library(WeibullR)
library(WeibullR.plotly)
failures<-c(30, 49, 82, 90, 96)
obj<-wblr.conf(wblr.fit(wblr(failures), method.fit = 'mle'), method.conf = 'lrb')
plotly_contour(obj)
}
