% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aiccrq.R
\name{aiccrq}
\alias{aiccrq}
\title{Akaike's Information Criterion for weighted quantile regression}
\usage{
aiccrq(mod_in, tau = 0.5)
}
\arguments{
\item{mod_in}{input crq model}

\item{tau}{numeric indicating quantile to evaluate}
}
\value{
AIC estimate
}
\description{
Get AIC values for a single weighted quantile regression as used in WRTDS models
}
\details{
The AIC value is based on the log-likelihood estimate of the model that accounts for the specific quantile, the minimum of the objective function (rho), and the number of model parameters.  The residuals are specific to the WRTDS model such that this function cannot be applied to arbitrary crq models.
}
\examples{
# get wts for a model centered on the first observation
ref_in <- tidobj[1, ]
ref_wts <- getwts(tidobj, ref_in)

# get the model
mod <- quantreg::crq(
   survival::Surv(res, not_cens, type = "left") ~ 
     dec_time + flo + sin(2*pi*dec_time) + cos(2*pi*dec_time), 
   weights = ref_wts,
   data = tidobj, 
   method = "Portnoy"
   )

aiccrq(mod)
}
