% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{WH_1d}
\alias{WH_1d}
\title{1D Whittaker-Henderson Smoothing}
\usage{
WH_1d(
  d,
  ec,
  lambda,
  criterion,
  method,
  q = 2,
  framework,
  y,
  wt,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{d}{Vector of observed events, should have named elements.}

\item{ec}{Vector of central exposure. The central exposure corresponds to the
sum of the exposure duration over the insured population. An individual
experiencing an event of interest during the year will no longer be exposed
afterward and the exposure should be computed accordingly.}

\item{lambda}{Smoothing parameter. If missing, an optimization procedure will
be used to find the optimal smoothing parameter. If supplied, no optimal
smoothing parameter search will take place unless the \code{method} argument is
also supplied, in which case \code{lambda} will be used as the starting
parameter for the optimization procedure.}

\item{criterion}{Criterion to be used for the selection of the optimal
smoothing parameter. Default is \code{"REML"} which stands for restricted
maximum likelihood. Other options include \code{"AIC"}, \code{"BIC"} and \code{"GCV"}.}

\item{method}{Method to be used to find the optimal smoothing parameter.
Default to \code{"fixed_lambda"} if \code{lambda} is supplied, meaning no
optimization is performed. Otherwise, default to the most reliable
\code{"outer"} method based on the \code{optimize} function from package \code{stats}.}

\item{q}{Order of penalization. Polynoms of degrees \code{q - 1} are considered
completely smooth and are therefore unpenalized. Should be left to the
default of \code{2} for most practical applications.}

\item{framework}{Default framework is \code{"ml"} which stands for maximum
likelihood unless the \code{y} argument is also provided, in which case an
\code{"reg"} or (approximate) regression framework is used.}

\item{y}{Optional vector of observations whose elements should be named. Used
only in the regression framework and if the \code{d} and \code{ec} arguments are
missing (otherwise \code{y} is automatically computed from \code{d} and \code{ec}). May be
useful when using Whittaker-Henderson smoothing outside of the survival
analysis framework.}

\item{wt}{Optional vector of weights. As for the observation vector \code{y}, used
only in the regression framework and if the \code{d} and \code{ec} arguments are
missing (otherwise \code{wt} is automatically set to \code{d}). May be useful when
using Whittaker-Henderson smoothing outside of the survival analysis
framework.}

\item{quiet}{Should messages and warnings be silenced ? Default to \code{FALSE},
may be set to \code{TRUE} is the function is called repeatedly.}

\item{...}{Additional parameters passed to the smoothing function called.}
}
\value{
An object of class \code{WH_1d} i.e. a list containing :
\itemize{
\item \code{d} The inputed vector of observed events (if supplied as input)
\item \code{ec} The inputed vector of central exposure (if supplied as input)
\item \code{y} The observation vector, either supplied or computed as y = log(d) - log(ec)
\item \code{wt} The inputed vector of weights, either supplied or computed as \code{d}
\item \code{y_hat} The vector of values fitted using Whittaker-Henderson smoothing
\item \code{std_y_hat} The vector of standard deviation associated with the fit
\item \code{res} The vector of deviance residuals associated with the fit
\item \code{edf_obs} The vector of effective degrees of freedom associated with each observation
\item \code{edf_par} The vector of effective degrees of freedom associated with each eigenvector
\item \code{diagnosis} A data.frame with one line containing the sum of effective degrees of freedom
for the model, the deviance of the fit as well as the AIC, BIC, GCV and
REML criteria
\item \code{Psi} The variance-covariance matrix associated with the fit, which is required
for the extrapolation step.
\item \code{lambda} The smoothing parameter used.
\item \code{p} The number of eigenvectors kept on each dimension if the rank reduction method
is used (it should not in the one-dimensional case).
\item \code{q} The supplied order for the penalization matrix.
}
}
\description{
Main package function to apply Whittaker-Henderson smoothing in a
one-dimensional survival analysis framework. It takes as input a vector of
observed events and a vector of associated central exposure, both depending
on a single covariate, and build a smooth version of the log-hazard rate.
Smoothing parameters may be supplied or automatically chosen according to an
adequate criterion such as \code{"REML"} (the default), \code{"AIC"}, \code{"BIC"} or
\code{"GCV"}. Whittaker-Henderson may be applied in a full maximum likelihood
framework (the default) or an approximate gaussian framework (the original).
}
\examples{
d <- portfolio_mort$d
ec <- portfolio_mort$ec

y <- log(d / ec)
y[d == 0] <- - 20
wt <- d

# Maximum likelihood
WH_1d(d, ec, lambda = 1e2)
WH_1d(d, ec) # default outer iteration method based on the optimize function
WH_1d(d, ec, criterion = "GCV")
# alternative optimization criterion for smoothing parameter selection

# Regression
WH_1d(y = y, wt = wt, lambda = 1e2) # regression framework is default when y is supplied
WH_1d(d, ec, framework = "reg", lambda = 1e2)
# setting framework = "reg" forces computation of y from d and ec

}
