% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise_VT.R
\name{stepwise.VT}
\alias{stepwise.VT}
\title{Calculate stepwise high order VT in calibration}
\usage{
stepwise.VT(
  data,
  alpha = 0.1,
  nvarmax = 4,
  mode = c("MRA", "MODWT", "AT"),
  wf,
  J,
  method = "dwt",
  pad = "zero",
  boundary = "periodic",
  cov.opt = "auto",
  flag = "biased",
  detrend = FALSE
)
}
\arguments{
\item{data}{A list of data, including response and predictors}

\item{alpha}{The significance level used to judge whether the sample estimate is significant. A default alpha value is 0.1.}

\item{nvarmax}{The maximum number of variables to be selected.}

\item{mode}{A mode of variance transformation, i.e., MRA, MODWT, or AT}

\item{wf}{Wavelet family}

\item{J}{Specifies the depth of the decomposition. This must be a number less than or equal to log(length(x),2).}

\item{method}{Either "dwt" or "modwt" of MRA.}

\item{pad}{The method used for extend data to dyadic size. Use "per", "zero", or "sym".}

\item{boundary}{Character string specifying the boundary condition. If boundary=="periodic" the default, then the vector you decompose is assumed to be periodic on its defined interval, if boundary=="reflection", the vector beyond its boundaries is assumed to be a symmetric reflection of itself.}

\item{cov.opt}{Options of Covariance matrix sign. Use "pos", "neg", or "auto".}

\item{flag}{Biased or Unbiased variance transformation.}

\item{detrend}{Detrend the input time series or just center, default (F).}
}
\value{
A list of 2 elements: the column numbers of the meaningful predictors (cpy), and partial informational correlation (cpyPIC).
}
\description{
Calculate stepwise high order VT in calibration
}
\examples{
### Real-world example
data("rain.mon")
data("obs.mon")
mode <- switch(1,
  "MRA",
  "MODWT",
  "AT"
)
wf <- "d4"
station.id <- 5 # station to investigate
#SPI.12 <- SPEI::spi(rain.mon, scale = 12)$fitted
SPI.12 <- SPI.calc(window(rain.mon, start=c(1949,1), end=c(2009,12)),sc=12)
lab.names <- colnames(obs.mon)
# plot.ts(SPI.12[,1:10])

x <- window(SPI.12[, station.id], start = c(1950, 1), end = c(1979, 12))
dp <- window(obs.mon[, lab.names], start = c(1950, 1), end = c(1979, 12))

data <- list(x = x, dp = matrix(dp, ncol = ncol(dp)))

dwt <- stepwise.VT(data, mode = mode, wf = wf, flag = "biased")

### plot transformed predictor before and after
cpy <- dwt$cpy
op <- par(mfrow = c(length(cpy), 1), mar = c(2, 3, 2, 1))
for (i in seq_along(cpy)) {
  ts.plot(cbind(dwt$dp[, i], dwt$dp.n[, i]), xlab = "NA", col = 1:2)
}
par(op)
}
\references{
Sharma, A., Mehrotra, R., 2014. An information theoretic alternative to model a natural system using observational information alone. Water Resources Research, 50(1): 650-660.

Jiang, Z., Sharma, A., & Johnson, F. (2021). Variable transformations in the spectral domain – Implications for hydrologic forecasting. Journal of Hydrology, 126816.
}
